/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.enancher;

import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.OpenIdConnectConfiguration;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.RequestEnhancer;
import org.springframework.util.MultiValueMap;

public class PKCERequestEnhancer
implements RequestEnhancer {
    private final StringKeyGenerator secureKeyGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 96);
    private final OpenIdConnectConfiguration config;

    public PKCERequestEnhancer(OpenIdConnectConfiguration oidcConfig) {
        this.config = oidcConfig;
    }

    public void enhance(AccessTokenRequest request, OAuth2ProtectedResourceDetails resource, MultiValueMap<String, String> form, HttpHeaders headers) {
        List codeVerifier;
        if (this.config.isSendClientSecret()) {
            form.put((Object)"client_secret", Collections.singletonList(resource.getClientSecret()));
        }
        if (this.config.isUsePKCE() && (codeVerifier = (List)request.get((Object)"code_verifier")) != null) {
            form.put((Object)"code_verifier", (Object)codeVerifier);
        }
    }
}

