/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.UserSessionService;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;

public class SessionTokenAuthenticationFilter
extends TokenAuthenticationFilter {
    private static final Logger LOGGER = LogManager.getLogger(SessionTokenAuthenticationFilter.class);
    @Autowired
    UserSessionService userSessionService;
    @Autowired
    UserService userService;
    private boolean validateUserFromService = true;

    @Override
    protected Authentication checkToken(String token) {
        if (this.userSessionService == null) {
            return null;
        }
        User ud = this.userSessionService.getUserData(token);
        if (ud != null) {
            User user = null;
            if (this.validateUserFromService) {
                if (ud.getId() != null) {
                    user = this.userService.get(ud.getId().longValue());
                }
                if (user == null && ud.getName() != null) {
                    try {
                        user = this.userService.get(ud.getName());
                    }
                    catch (NotFoundServiceEx e) {
                        LOGGER.error("User " + ud.getName() + " not found on the database because of an exception", (Throwable)e);
                    }
                }
            } else {
                user = ud;
            }
            if (user != null) {
                return this.createAuthenticationForUser(user);
            }
            LOGGER.error("User login success, but couldn't retrieve  a session. Probably auth user and  and userService are out of sync.");
        }
        return null;
    }

    public UserSessionService getUserSessionService() {
        return this.userSessionService;
    }

    public void setUserSessionService(UserSessionService userSessionService) {
        this.userSessionService = userSessionService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    @Override
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public boolean isValidateUserFromService() {
        return this.validateUserFromService;
    }

    public void setValidateUserFromService(boolean validateUserFromService) {
        this.validateUserFromService = validateUserFromService;
    }
}

