/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;

public class GeoStoreAuthenticationConverter
extends DefaultUserAuthenticationConverter {
    protected static Logger LOGGER = LogManager.getLogger(GeoStoreAuthenticationConverter.class);
    private Object usernameKey = "user_name";

    public GeoStoreAuthenticationConverter() {
    }

    public GeoStoreAuthenticationConverter(String username_key) {
        this.usernameKey = username_key;
    }

    public Authentication extractAuthentication(Map<String, ?> map) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Extracting authentication from a map with following keys: " + map.keySet().stream().collect(Collectors.joining(",")));
        }
        if (map.containsKey(this.usernameKey)) {
            return new UsernamePasswordAuthenticationToken(map.get(this.usernameKey), (Object)"N/A", null);
        }
        return null;
    }
}

