/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2.google;

import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreAccessTokenConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;

public class GoogleAccessTokenConverter
extends GeoStoreAccessTokenConverter {
    public GoogleAccessTokenConverter(String principalKey) {
        super(principalKey);
    }

    @Override
    public OAuth2Authentication extractAuthentication(Map<String, ?> map) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Set<String> scope = this.parseScopes(map);
        Authentication user = this.userTokenConverter.extractAuthentication(map);
        String clientId = (String)map.get("client_id");
        parameters.put("client_id", clientId);
        Object aud = map.get("aud");
        LinkedHashSet<String> resourceIds = new LinkedHashSet<String>();
        if (aud instanceof Collection) {
            ((Collection)aud).stream().forEach(a -> resourceIds.add(a.toString()));
        } else if (aud instanceof String) {
            resourceIds.add(aud.toString());
        }
        OAuth2Request request = new OAuth2Request(parameters, clientId, null, true, scope, resourceIds, null, null, null);
        return new OAuth2Authentication(request, user);
    }

    private Set<String> parseScopes(Map<String, ?> map) {
        String scopeAsObject = map.containsKey("scope") ? map.get("scope") : "";
        LinkedHashSet<String> scope = new LinkedHashSet<String>();
        if (String.class.isAssignableFrom(scopeAsObject.getClass())) {
            String scopeAsString = scopeAsObject;
            Collections.addAll(scope, scopeAsString.split(" "));
        } else if (Collection.class.isAssignableFrom(scopeAsObject.getClass())) {
            Collection scopes = (Collection)((Object)scopeAsObject);
            scope.addAll(scopes);
        }
        return scope;
    }
}

