/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkTokenStore;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class GeoStoreOAuthRestTemplate
extends OAuth2RestTemplate {
    public static final String ID_TOKEN_VALUE = "OpenIdConnect-IdTokenValue";
    private static final Logger LOGGER = LogManager.getLogger(GeoStoreOAuthRestTemplate.class);
    private final String idTokenParam;
    private JwkTokenStore store;

    public GeoStoreOAuthRestTemplate(OAuth2ProtectedResourceDetails resource, OAuth2ClientContext context, OAuth2Configuration configuration) {
        this(resource, context, configuration, "id_token");
    }

    public GeoStoreOAuthRestTemplate(OAuth2ProtectedResourceDetails resource, OAuth2ClientContext context, OAuth2Configuration configuration, String idTokenParam) {
        super(resource, context);
        if (configuration.getIdTokenUri() != null) {
            this.store = new JwkTokenStore(configuration.getIdTokenUri());
        }
        this.idTokenParam = idTokenParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OAuth2AccessToken acquireAccessToken(OAuth2ClientContext oauth2Context) throws UserRedirectRequiredException {
        OAuth2AccessToken result = null;
        try {
            OAuth2AccessToken oAuth2AccessToken = result = super.acquireAccessToken(oauth2Context);
            return oAuth2AccessToken;
        }
        finally {
            AccessTokenRequest accessTokenRequest;
            if (oauth2Context != null && oauth2Context.getAccessTokenRequest() != null && (accessTokenRequest = oauth2Context.getAccessTokenRequest()).getAuthorizationCode() != null && !accessTokenRequest.getAuthorizationCode().isEmpty()) {
                LOGGER.info("OIDC: received a CODE from Identity Provider - handing it in for ID/Access Token");
                LOGGER.info("OIDC: CODE={}", (Object)accessTokenRequest.getAuthorizationCode());
                if (result != null) {
                    LOGGER.info("OIDC: Identity Provider returned Token, type={}", (Object)result.getTokenType());
                    LOGGER.info("OIDC: SCOPES={}", (Object)String.join((CharSequence)" ", result.getScope()));
                    String accessToken = result.getValue();
                    LOGGER.info("OIDC: ACCESS TOKEN:{}", (Object)this.saferJWT(accessToken));
                    Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).setAttribute("access_token", (Object)accessToken, 0);
                    if (result.getAdditionalInformation().containsKey("refresh_token")) {
                        String refreshToken = (String)result.getAdditionalInformation().get("refresh_token");
                        LOGGER.info("OIDC: REFRESH TOKEN:{}", (Object)this.saferJWT(refreshToken));
                        RequestContextHolder.getRequestAttributes().setAttribute("refresh_token", (Object)accessToken, 0);
                    }
                    if (result.getAdditionalInformation().containsKey("id_token")) {
                        String idToken = (String)result.getAdditionalInformation().get("id_token");
                        LOGGER.info("OIDC: ID TOKEN:{}", (Object)this.saferJWT(idToken));
                        RequestContextHolder.getRequestAttributes().setAttribute("id_token", (Object)accessToken, 0);
                    }
                }
            }
        }
    }

    String saferJWT(String jwt) {
        String[] JWTParts = jwt.split("\\.");
        if (JWTParts.length > 1) {
            return JWTParts[1];
        }
        return "NOT A JWT";
    }

    public OAuth2AccessToken getAccessToken() throws UserRedirectRequiredException {
        OAuth2AccessToken token = super.getAccessToken();
        if (token != null) {
            this.validate(token);
        }
        return token;
    }

    private void validate(OAuth2AccessToken token) {
        Object maybeIdToken = token.getAdditionalInformation().get("id_token");
        if (maybeIdToken instanceof String) {
            String idToken = (String)maybeIdToken;
            this.setAsRequestAttribute(ID_TOKEN_VALUE, idToken);
            if (this.store != null) {
                this.store.readAuthentication(idToken);
            }
        }
    }

    private void setAsRequestAttribute(String key, String value) {
        Optional.ofNullable(RequestContextHolder.getRequestAttributes()).filter(ra -> ra instanceof ServletRequestAttributes).map(ra -> (ServletRequestAttributes)ra).map(ServletRequestAttributes::getRequest).ifPresent(r -> r.setAttribute(key, (Object)value));
    }

    public OAuth2Authentication readAuthentication(String idToken) {
        return this.store.readAuthentication(idToken);
    }

    public void setTokenStore(JwkTokenStore jwkTokenStore) {
        this.store = jwkTokenStore;
    }
}

