/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2.openid_connect;

import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.oauth2.DiscoveryClient;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreOAuthRestTemplate;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2GeoStoreAuthenticationFilter;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.OpenIdConnectConfiguration;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.bearer.OpenIdTokenValidator;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;

public class OpenIdConnectFilter
extends OAuth2GeoStoreAuthenticationFilter {
    private static final Logger LOGGER = LogManager.getLogger(OpenIdConnectFilter.class);
    private final OpenIdTokenValidator bearerTokenValidator;

    public OpenIdConnectFilter(RemoteTokenServices tokenServices, GeoStoreOAuthRestTemplate oAuth2RestTemplate, OAuth2Configuration configuration, TokenAuthenticationCache tokenAuthenticationCache, OpenIdTokenValidator bearerTokenValidator) {
        super(tokenServices, oAuth2RestTemplate, configuration, tokenAuthenticationCache);
        if (configuration.getDiscoveryUrl() != null && !"".equals(configuration.getDiscoveryUrl())) {
            new DiscoveryClient(configuration.getDiscoveryUrl()).autofill(configuration);
        }
        this.bearerTokenValidator = bearerTokenValidator;
    }

    @Override
    protected String getPreAuthenticatedPrincipal(HttpServletRequest req, HttpServletResponse resp, OAuth2AccessToken accessToken) throws IOException, ServletException {
        String result = super.getPreAuthenticatedPrincipal(req, resp, accessToken);
        OAuth2GeoStoreAuthenticationFilter.OAuth2AuthenticationType type = (OAuth2GeoStoreAuthenticationFilter.OAuth2AuthenticationType)((Object)req.getAttribute("oauth2.authenticationType"));
        if (type != null && type.equals((Object)OAuth2GeoStoreAuthenticationFilter.OAuth2AuthenticationType.BEARER) && this.bearerTokenValidator != null) {
            JSONObject accessTokenClaims;
            Object fromOurFlow;
            Object fromSpring;
            if (!((OpenIdConnectConfiguration)this.configuration).isAllowBearerTokens()) {
                LOGGER.warn("OIDC: received an attached Bearer token, but Bearer tokens aren't allowed!");
                throw new IOException("OIDC: received an attached Bearer token, but Bearer tokens aren't allowed!");
            }
            String token = null;
            if (accessToken != null && !accessToken.isExpired() && accessToken.getValue() != null && !accessToken.getValue().isEmpty()) {
                token = accessToken.getValue();
            }
            if (token == null && (fromSpring = req.getAttribute(OAuth2AuthenticationDetails.ACCESS_TOKEN_VALUE)) instanceof String) {
                token = (String)fromSpring;
            }
            if (token == null && (fromOurFlow = req.getAttribute("access_token")) instanceof String) {
                token = (String)fromOurFlow;
            }
            if (token == null || token.isEmpty()) {
                LOGGER.error("OIDC: Bearer token validation requested but no token was found in request context");
                throw new IOException("Attached Bearer Token is missing");
            }
            Map userinfoMap = null;
            Object ext = req.getAttribute("oauth2.AccessTokenCheckResponse");
            if (ext instanceof Map) {
                userinfoMap = (Map)ext;
            }
            try {
                Jwt decodedAccessToken = JwtHelper.decode((String)token);
                String claimsJson = decodedAccessToken.getClaims();
                accessTokenClaims = JSONObject.fromObject((Object)claimsJson);
            }
            catch (Exception e) {
                LOGGER.error("OIDC: Could not decode bearer token claims", (Throwable)e);
                throw new IOException("Attached Bearer Token is invalid (decoding failed)", e);
            }
            try {
                this.bearerTokenValidator.verifyToken((OpenIdConnectConfiguration)this.configuration, (Map)accessTokenClaims, userinfoMap);
            }
            catch (Exception e) {
                throw new IOException("Attached Bearer Token is invalid", e);
            }
        }
        return result;
    }
}

