/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2.openid_connect;

import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreRemoteTokenServices;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.OpenIdConnectAccessTokenConverter;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class OpenIdConnectTokenServices
extends GeoStoreRemoteTokenServices {
    public OpenIdConnectTokenServices(String principalKey) {
        super((AccessTokenConverter)new OpenIdConnectAccessTokenConverter(principalKey));
        LOGGER.info("Instantiating OpenIdConnectAccessTokenConverter with principalKey: {}", (Object)principalKey);
    }

    @Override
    protected Map<String, Object> checkToken(String accessToken) {
        LOGGER.info("Checking token: {}", (Object)accessToken);
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)"token", (Object)accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", this.getAuthorizationHeader(accessToken));
        LOGGER.info("Headers: {}", (Object)headers);
        String accessTokenUrl = this.checkTokenEndpointUrl + "?access_token=" + accessToken;
        LOGGER.info("Checking token with url: {}", (Object)accessTokenUrl);
        Map<String, Object> reults = this.sendRequestForMap(accessTokenUrl, (MultiValueMap<String, String>)formData, headers, HttpMethod.GET);
        LOGGER.info("Got sendRequestForMap results: {}", reults);
        return reults;
    }
}

