/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security.keycloak;

import com.fasterxml.jackson.core.JsonProcessingException;
import it.geosolutions.geostore.rest.security.keycloak.KeycloakTestSupport;
import it.geosolutions.geostore.services.rest.IdPLoginRest;
import it.geosolutions.geostore.services.rest.model.SessionToken;
import it.geosolutions.geostore.services.rest.security.IdPConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakLoginService;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakTokenDetails;
import it.geosolutions.geostore.services.rest.security.oauth2.IdPLoginRestImpl;
import it.geosolutions.geostore.services.rest.security.oauth2.InMemoryTokenStorage;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class KeycloakLoginTest
extends KeycloakTestSupport {
    private IdPLoginRest loginRest;
    private Object key;

    @Before
    public void setUp() throws JsonProcessingException {
        this.setUpAdapter("https://cas.core.maui.mda.ca:8040/auth");
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((AdapterConfig)this.adapterConfig);
        KeyCloakConfiguration configuration = this.createConfiguration();
        this.loginRest = new IdPLoginRestImpl();
        InMemoryTokenStorage storage = new InMemoryTokenStorage();
        this.key = storage.buildTokenKey();
        SessionToken token = new SessionToken();
        token.setAccessToken("access_token");
        token.setRefreshToken("refresh_token");
        storage.saveToken(this.key, token);
        new KeyCloakLoginService(this.loginRest, (TokenStorage)storage, configuration){
            final /* synthetic */ TokenStorage val$storage;
            final /* synthetic */ KeyCloakConfiguration val$configuration;
            {
                this.val$storage = tokenStorage;
                this.val$configuration = keyCloakConfiguration;
                super(loginRest);
            }

            protected TokenStorage tokenStorage() {
                return this.val$storage;
            }

            protected IdPConfiguration configuration(String provider) {
                return this.val$configuration;
            }
        };
    }

    @Test
    public void testLoginEndpoint() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
        AuthenticationEntryPoint entryPoint = new AuthenticationEntryPoint(){

            public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
                response.sendRedirect("/");
            }
        };
        attributes.setAttribute("KEYCLOAK_REDIRECT", (Object)entryPoint, 0);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        this.loginRest.login("keycloak");
        Assert.assertEquals((long)302L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getRedirectedUrl());
    }

    @Test
    public void testLoginEndpointInternalRedirect() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse httpResponse = new MockHttpServletResponse();
        ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)httpResponse);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        PreAuthenticatedAuthenticationToken authentication = new PreAuthenticatedAuthenticationToken((Object)"username", (Object)"", new ArrayList());
        KeycloakTokenDetails details = new KeycloakTokenDetails("accessToken", "refreshToken", 10202L);
        authentication.setDetails((Object)details);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        Response response = this.loginRest.callback("keycloak");
        Assert.assertEquals((long)302L, (long)response.getStatus());
        Assert.assertEquals((Object)"../../../", (Object)response.getHeaderString("Location"));
        MultivaluedMap meta = response.getMetadata();
        List cookies = (List)meta.get((Object)"Set-Cookie");
        List tokenCookies = cookies.stream().filter(c -> ((String)c).contains("authProvider") || ((String)c).contains("tokens_key")).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)tokenCookies.size());
    }

    @Test
    public void testGetTokenByIdentifier() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse httpResponse = new MockHttpServletResponse();
        ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)httpResponse);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        PreAuthenticatedAuthenticationToken authentication = new PreAuthenticatedAuthenticationToken((Object)"username", (Object)"", new ArrayList());
        KeycloakTokenDetails details = new KeycloakTokenDetails("accessToken", "refreshToken", 10202L);
        authentication.setDetails((Object)details);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        SessionToken sessionToken = this.loginRest.getTokensByTokenIdentifier("keycloak", this.key.toString());
        Assert.assertEquals((Object)"access_token", (Object)sessionToken.getAccessToken());
        Assert.assertEquals((Object)"refresh_token", (Object)sessionToken.getRefreshToken());
    }

    @After
    public void afterTest() {
        RequestContextHolder.resetRequestAttributes();
        SecurityContextHolder.clearContext();
    }
}

