/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security.oauth2;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreOAuthRestTemplate;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreRemoteTokenServices;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.google.OAuthGoogleSecurityConfiguration;
import it.geosolutions.geostore.services.rest.security.oauth2.google.OpenIdFilter;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OpenIdIntegrationTest {
    private static final String CLIENT_ID = "kbyuFDidLLm280LIwVFiazOqjO3ty8KH";
    private static final String CLIENT_SECRET = "60Op4HFM0I8ajz0WdiStAbziZ-VFQttXuxixHHs2R7r7-CW8GR79l-mmLqMhc-Sa";
    private static final String CODE = "R-2CqM7H1agwc7Cx";
    private static WireMockServer openIdService;
    private String authService;
    private OpenIdFilter filter;
    private OAuth2Configuration configuration;

    @BeforeClass
    public static void beforeClass() {
        openIdService = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().notifier((Notifier)new ConsoleNotifier(true)));
        openIdService.start();
        openIdService.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/certs")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("jkws.json")));
        openIdService.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withRequestBody(WireMock.containing((String)"grant_type=authorization_code")).withRequestBody(WireMock.containing((String)"client_id=kbyuFDidLLm280LIwVFiazOqjO3ty8KH")).withRequestBody(WireMock.containing((String)"code=R-2CqM7H1agwc7Cx")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("token_response.json")));
        openIdService.stubFor(WireMock.any((UrlPattern)WireMock.urlPathEqualTo((String)"/userinfo")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("userinfo.json")));
    }

    @Before
    public void before() {
        OpenIdFilter filter;
        this.authService = "http://localhost:" + openIdService.port();
        final OAuth2Configuration configuration = new OAuth2Configuration();
        configuration.setClientId(CLIENT_ID);
        configuration.setClientSecret(CLIENT_SECRET);
        configuration.setRevokeEndpoint(this.authService + "/revoke");
        configuration.setAccessTokenUri(this.authService + "/token");
        configuration.setAuthorizationUri(this.authService + "/authorize");
        configuration.setCheckTokenEndpointUrl(this.authService + "/userinfo");
        configuration.setEnabled(true);
        configuration.setAutoCreateUser(true);
        configuration.setIdTokenUri(this.authService + "/certs");
        configuration.setBeanName("googleOAuth2Config");
        configuration.setEnableRedirectEntryPoint(true);
        configuration.setRedirectUri("../../../geostore/rest/users/user/details");
        configuration.setScopes("openId,email");
        this.configuration = configuration;
        OAuthGoogleSecurityConfiguration securityConfiguration = new OAuthGoogleSecurityConfiguration(){

            protected GeoStoreOAuthRestTemplate restTemplate() {
                return new GeoStoreOAuthRestTemplate(this.resourceDetails(), (OAuth2ClientContext)new DefaultOAuth2ClientContext((AccessTokenRequest)new DefaultAccessTokenRequest()), this.configuration());
            }

            public OAuth2Configuration configuration() {
                return configuration;
            }
        };
        GeoStoreOAuthRestTemplate restTemplate = securityConfiguration.oauth2RestTemplate();
        this.filter = filter = new OpenIdFilter((GeoStoreRemoteTokenServices)securityConfiguration.googleTokenServices(), restTemplate, configuration, securityConfiguration.oAuth2Cache());
    }

    @After
    public void afterTest() {
        SecurityContextHolder.clearContext();
        RequestContextHolder.resetRequestAttributes();
    }

    @Test
    public void testRedirect() throws IOException, ServletException {
        MockHttpServletRequest request = this.createRequest("google/login");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)302L, (long)response.getStatus());
        Assert.assertEquals((Object)response.getRedirectedUrl(), (Object)this.configuration.buildLoginUri());
    }

    @Test
    public void testAuthentication() throws IOException, ServletException {
        MockHttpServletRequest request = this.createRequest("google/login");
        request.setParameter("authorization_code", CODE);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.filter.restTemplate.getOAuth2ClientContext().getAccessTokenRequest().setAuthorizationCode(CODE);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = (User)authentication.getPrincipal();
        Assert.assertEquals((Object)"ritter@erdukunde.de", (Object)user.getName());
        Assert.assertEquals((Object)Role.USER, (Object)user.getRole());
    }

    @Test
    public void testGroupsAndRolesFromToken() throws IOException, ServletException {
        this.configuration.setGroupsClaim("hd");
        MockHttpServletRequest request = this.createRequest("google/login");
        request.setParameter("authorization_code", CODE);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.filter.restTemplate.getOAuth2ClientContext().getAccessTokenRequest().setAuthorizationCode(CODE);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = (User)authentication.getPrincipal();
        Assert.assertEquals((Object)"ritter@erdukunde.de", (Object)user.getName());
        Assert.assertEquals((Object)Role.USER, (Object)user.getRole());
        UserGroup group = (UserGroup)user.getGroups().stream().findAny().get();
        Assert.assertEquals((Object)"geosolutionsgroup.com", (Object)group.getGroupName());
    }

    private MockHttpServletRequest createRequest(String path) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        request.setServerName("localhost");
        request.setServerPort(8080);
        request.setContextPath("/geostore");
        request.setRequestURI("/geostore/" + path);
        request.setRemoteAddr("127.0.0.1");
        request.setServletPath("/geostore");
        request.setPathInfo(path);
        request.addHeader("Host", (Object)"localhost:8080");
        ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        return request;
    }
}

