/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.service.impl;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.impl.RESTResourceServiceImpl;
import it.geosolutions.geostore.services.rest.model.RESTAttribute;
import it.geosolutions.geostore.services.rest.utils.MockSecurityContext;
import java.util.ArrayList;
import javax.ws.rs.core.SecurityContext;
import org.junit.Before;
import org.junit.Test;

public class RESTResourceServiceImplTest
extends ServiceTestBase {
    RESTResourceServiceImpl restService;
    long adminID;

    @Before
    public void setUp() throws BadRequestServiceEx, NotFoundServiceEx {
        this.restService = new RESTResourceServiceImpl();
        this.restService.setResourceService(resourceService);
    }

    @Test
    public void testUpdateResource_editorUpdate() throws Exception {
        long u0ID = this.createUser("u0", Role.USER, "p0");
        User user = new User();
        user.setId(Long.valueOf(u0ID));
        user.setName("u0");
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        SecurityRule rule = new SecurityRule();
        rule.setUser(user);
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rules.add(rule);
        long groupId = this.createGroup("group1");
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(groupId));
        rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setGroup(group);
        rules.add(rule);
        long resourceId = this.createResource("name1", "description1", "MAP", rules);
        MockSecurityContext sc = new MockSecurityContext(userService.get(u0ID));
        RESTAttribute attribute = new RESTAttribute();
        String NAME = "NAME";
        String VALUE = "VALUE";
        attribute.setName(NAME);
        attribute.setValue(VALUE);
        this.restService.updateAttribute((SecurityContext)sc, resourceId, attribute);
        Resource sr = this.restService.get((SecurityContext)sc, resourceId, false);
        Attribute a = (Attribute)sr.getAttribute().get(0);
        RESTResourceServiceImplTest.assertEquals((String)a.getName(), (String)NAME);
        RESTResourceServiceImplTest.assertEquals((String)a.getValue(), (String)VALUE);
        RESTResourceServiceImplTest.assertEquals((Object)a.getType(), (Object)DataType.STRING);
        RESTResourceServiceImplTest.assertEquals((String)sr.getCreator(), (String)"u0");
        RESTResourceServiceImplTest.assertEquals((String)sr.getEditor(), (String)"u0");
        long u1ID = this.createUser("u1", Role.USER, "p1", groupId);
        user = new User();
        user.setId(Long.valueOf(u1ID));
        user.setName("u1");
        sc = new MockSecurityContext(userService.get(u1ID));
        attribute = new RESTAttribute();
        NAME = "NAME";
        VALUE = "VALUE1";
        attribute.setName(NAME);
        attribute.setValue(VALUE);
        this.restService.updateAttribute((SecurityContext)sc, resourceId, attribute);
        sr = this.restService.get((SecurityContext)sc, resourceId, false);
        a = (Attribute)sr.getAttribute().get(0);
        RESTResourceServiceImplTest.assertEquals((String)a.getName(), (String)NAME);
        RESTResourceServiceImplTest.assertEquals((String)a.getValue(), (String)VALUE);
        RESTResourceServiceImplTest.assertEquals((Object)a.getType(), (Object)DataType.STRING);
        RESTResourceServiceImplTest.assertEquals((String)sr.getCreator(), (String)"u0");
        RESTResourceServiceImplTest.assertEquals((String)sr.getEditor(), (String)"u1");
    }
}

