/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.MockLdapAuthenticator;
import it.geosolutions.geostore.services.rest.security.MockLdapAuthoritiesPopulator;
import it.geosolutions.geostore.services.rest.security.UserLdapAuthenticationProvider;
import it.geosolutions.geostore.services.rest.utils.MockedUserGroupService;
import it.geosolutions.geostore.services.rest.utils.MockedUserService;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class UserLdapAuthenticationProviderTest {
    private static final String TEST_GROUP = "testgroup";
    private UserLdapAuthenticationProvider provider;
    private MockedUserService userService;
    private MockedUserGroupService userGroupService;

    @Before
    public void setUp() {
        this.provider = new UserLdapAuthenticationProvider((LdapAuthenticator)new MockLdapAuthenticator(), (LdapAuthoritiesPopulator)new MockLdapAuthoritiesPopulator(){

            @Override
            public Set<GrantedAuthority> getAllGroups() {
                return Collections.singleton(new SimpleGrantedAuthority(UserLdapAuthenticationProviderTest.TEST_GROUP));
            }
        });
        this.userService = new MockedUserService();
        this.userGroupService = new MockedUserGroupService();
        this.provider.setUserService((UserService)this.userService);
        this.provider.setUserGroupService((UserGroupService)this.userGroupService);
    }

    @Test
    public void testNullPassword() throws NotFoundServiceEx {
        this.provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password"));
        User user = this.userService.get("user");
        Assert.assertNotNull((Object)user);
        Assert.assertNull((Object)user.getPassword());
    }

    @Test
    public void testSynchronizeGroups() throws BadRequestServiceEx {
        Assert.assertNull((Object)this.userGroupService.get(TEST_GROUP));
        this.provider.synchronizeGroups();
        Assert.assertNotNull((Object)this.userGroupService.get(TEST_GROUP));
    }
}

