/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.security.password.PwEncoder;
import it.geosolutions.geostore.services.UserService;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserServiceAuthenticationProvider
implements AuthenticationProvider {
    public static final String USER_NOT_FOUND_MSG = "User not found. Please check your credentials";
    public static final String USER_NOT_ENABLED = "The user present but not enabled";
    private static final Logger LOGGER = LogManager.getLogger(UserServiceAuthenticationProvider.class);
    private static final String UNAUTHORIZED_MSG = "Bad credentials";
    @Autowired
    UserService userService;

    public boolean supports(Class<? extends Object> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }

    public Authentication authenticate(Authentication authentication) {
        String pw = (String)authentication.getCredentials();
        String us = (String)authentication.getPrincipal();
        User user = null;
        try {
            user = this.userService.get(us);
            LOGGER.info("US: " + us);
            if (user.getPassword() == null || !PwEncoder.isPasswordValid((String)user.getPassword(), (String)pw)) {
                throw new BadCredentialsException(UNAUTHORIZED_MSG);
            }
            if (!user.isEnabled()) {
                throw new DisabledException(USER_NOT_FOUND_MSG);
            }
        }
        catch (Exception e) {
            LOGGER.info("Error while authenticating user", (Throwable)e);
            user = null;
        }
        if (user != null) {
            String role = user.getRole().toString();
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            authorities.add(new SimpleGrantedAuthority("ROLE_" + role));
            UsernamePasswordAuthenticationToken a = new UsernamePasswordAuthenticationToken((Object)user, (Object)pw, authorities);
            return a;
        }
        throw new UsernameNotFoundException(USER_NOT_FOUND_MSG);
    }
}

