/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.security.password.SecurityUtils;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.rest.RESTSessionService;
import it.geosolutions.geostore.services.rest.SessionServiceDelegate;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.SessionToken;
import it.geosolutions.geostore.services.rest.security.IdPConfiguration;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenDetails;
import it.geosolutions.geostore.services.rest.utils.GeoStoreContext;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class OAuth2SessionServiceDelegate
implements SessionServiceDelegate {
    private static final Logger LOGGER = LogManager.getLogger(OAuth2SessionServiceDelegate.class);
    private static final long CLOCK_SKEW_ALLOWANCE_MILLIS = 300000L;
    protected UserService userService;

    public OAuth2SessionServiceDelegate(RESTSessionService restSessionService, String delegateName, UserService userService) {
        restSessionService.registerDelegate(delegateName, (SessionServiceDelegate)this);
        this.userService = userService;
    }

    public OAuth2SessionServiceDelegate(RestTemplate restTemplate, OAuth2Configuration configuration) {
    }

    public SessionToken refresh(String refreshToken, String accessToken) {
        Object errorMessage = "";
        String warningMessage = "";
        HttpServletRequest request = this.getRequest();
        if (accessToken == null || accessToken.isEmpty()) {
            accessToken = OAuth2Utils.tokenFromParamsOrBearer("access_token", request);
        }
        if (accessToken == null || accessToken.isEmpty()) {
            throw new NotFoundWebEx("Either the accessToken or the refresh token are missing");
        }
        OAuth2AccessToken currentToken = this.retrieveAccessToken(accessToken, null);
        String refreshTokenToUse = Optional.ofNullable(currentToken.getRefreshToken()).map(OAuth2RefreshToken::getValue).filter(value -> !value.isEmpty()).orElse(refreshToken);
        if (refreshTokenToUse == null || refreshTokenToUse.isEmpty()) {
            refreshTokenToUse = OAuth2Utils.getParameterValue("refresh_token", request);
        }
        SessionToken sessionToken = null;
        OAuth2Configuration configuration = this.configuration();
        if (configuration != null && configuration.isEnabled()) {
            LOGGER.info("Attempting to refresh the token.");
            try {
                sessionToken = this.doRefresh(refreshTokenToUse, accessToken, configuration);
                if (sessionToken != null) {
                    currentToken = this.retrieveAccessToken(sessionToken.getAccessToken(), sessionToken.getExpires());
                }
            }
            catch (UserRedirectRequiredException e) {
                warningMessage = "A redirect is required to get the user's approval.";
                LOGGER.warn(warningMessage, (Throwable)e);
            }
            catch (Exception e) {
                errorMessage = "An error occurred during token refresh: " + e.getMessage();
                LOGGER.error((String)errorMessage, (Throwable)e);
            }
        } else {
            LOGGER.warn("Configuration is null or disabled; skipping token refresh.");
        }
        if (sessionToken == null) {
            if (this.isTokenExpired(currentToken)) {
                errorMessage = "Token is invalid or expired, and refresh failed.";
                LOGGER.error((String)errorMessage);
                this.handleRefreshFailure(accessToken, refreshTokenToUse, configuration);
                return null;
            }
            if (warningMessage.isEmpty()) {
                warningMessage = "Using existing access token.";
            }
            sessionToken = this.sessionToken(accessToken, refreshTokenToUse, currentToken.getExpiration());
        }
        if (!warningMessage.isEmpty()) {
            sessionToken.setWarning(warningMessage);
        }
        if (!((String)errorMessage).isEmpty()) {
            sessionToken.setError((String)errorMessage);
        }
        request.setAttribute(OAuth2AuthenticationDetails.ACCESS_TOKEN_VALUE, (Object)sessionToken.getAccessToken());
        request.setAttribute(OAuth2AuthenticationDetails.ACCESS_TOKEN_TYPE, (Object)sessionToken.getTokenType());
        return sessionToken;
    }

    private boolean isTokenExpired(OAuth2AccessToken token) {
        if (token == null || token.getValue().isEmpty()) {
            return true;
        }
        Date expiration = token.getExpiration();
        if (expiration == null && (expiration = this.getExpirationDateFromToken(token.getValue())) == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        long adjustedExpirationTime = expiration.getTime() + 300000L;
        return adjustedExpirationTime <= now;
    }

    private Date getExpirationDateFromToken(String token) {
        try {
            Jwt decodedToken = JwtHelper.decode((String)token);
            String claimsJson = decodedToken.getClaims();
            ObjectMapper mapper = new ObjectMapper();
            Map claims = (Map)mapper.readValue(claimsJson, Map.class);
            Object exp = claims.get("exp");
            if (exp != null) {
                long expLong;
                if (exp instanceof Integer) {
                    expLong = ((Integer)exp).longValue();
                } else if (exp instanceof Long) {
                    expLong = (Long)exp;
                } else if (exp instanceof String) {
                    expLong = Long.parseLong((String)exp);
                } else {
                    throw new IllegalArgumentException("Cannot parse 'exp' claim from token");
                }
                return new Date(expLong * 1000L);
            }
            return null;
        }
        catch (InvalidSignatureException e) {
            LOGGER.error("Invalid JWT signature: {}", (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse JWT token: {}", (Object)e.getMessage());
            return null;
        }
    }

    protected SessionToken doRefresh(String refreshToken, String accessToken, OAuth2Configuration configuration) {
        int maxRetries;
        SessionToken sessionToken = null;
        int attempt = 0;
        String errorMessage = "";
        String warningMessage = "";
        OAuth2RestTemplate restTemplate = this.restTemplate();
        HttpHeaders headers = OAuth2SessionServiceDelegate.getHttpHeaders(accessToken, configuration);
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"grant_type", (Object)"refresh_token");
        requestBody.add((Object)"refresh_token", (Object)refreshToken);
        requestBody.add((Object)"client_secret", (Object)configuration.getClientSecret());
        requestBody.add((Object)"client_id", (Object)configuration.getClientId());
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        long backoffDelay = configuration.getInitialBackoffDelay();
        int n = maxRetries = configuration.getMaxRetries() > 0 ? configuration.getMaxRetries() : 1;
        while (attempt < maxRetries) {
            block13: {
                LOGGER.info("Attempting to refresh token, attempt {} of {}", (Object)(++attempt), (Object)maxRetries);
                try {
                    ResponseEntity response = restTemplate.exchange(configuration.buildRefreshTokenURI(), HttpMethod.POST, requestEntity, OAuth2AccessToken.class, new Object[0]);
                    if (response.getStatusCode().is2xxSuccessful()) {
                        OAuth2AccessToken newToken = (OAuth2AccessToken)response.getBody();
                        if (newToken != null && !this.isTokenExpired(newToken)) {
                            OAuth2RefreshToken newRefreshToken = newToken.getRefreshToken();
                            DefaultOAuth2RefreshToken refreshTokenToUse = newRefreshToken != null && newRefreshToken.getValue() != null ? newRefreshToken : new DefaultOAuth2RefreshToken(refreshToken);
                            this.updateAuthToken(accessToken, newToken, (OAuth2RefreshToken)refreshTokenToUse, configuration);
                            sessionToken = this.sessionToken(newToken.getValue(), refreshTokenToUse.getValue(), newToken.getExpiration());
                            LOGGER.info("Token refreshed successfully on attempt {}", (Object)attempt);
                            attempt = maxRetries;
                            break;
                        }
                        LOGGER.warn("Received invalid or expired token on attempt {}", (Object)attempt);
                    } else {
                        if (response.getStatusCode().is4xxClientError()) {
                            LOGGER.error("Client error occurred: {}. Stopping further attempts.", (Object)response.getStatusCode());
                            break;
                        }
                        LOGGER.warn("Server error occurred: {}. Retrying...", (Object)response.getStatusCode());
                    }
                }
                catch (UserRedirectRequiredException e) {
                    warningMessage = "A redirect is required to get the user's approval.";
                    LOGGER.warn(warningMessage);
                    sessionToken = this.sessionToken(accessToken, refreshToken, null);
                    sessionToken.setWarning(warningMessage);
                    attempt = maxRetries;
                    break;
                }
                catch (RestClientException ex) {
                    LOGGER.error("Attempt {}: Error refreshing token: {}", (Object)attempt, (Object)ex.getMessage());
                    if (attempt != maxRetries) break block13;
                    errorMessage = "Max retries reached. Unable to refresh token.";
                    LOGGER.error(errorMessage);
                    break;
                }
            }
            if (attempt >= maxRetries) continue;
            try {
                LOGGER.info("Waiting for {} ms before next retry.", (Object)backoffDelay);
                Thread.sleep(backoffDelay);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Backoff delay interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            backoffDelay = (long)((double)backoffDelay * configuration.getBackoffMultiplier());
        }
        if (sessionToken == null) {
            try {
                this.handleRefreshFailure(accessToken, refreshToken, configuration);
            }
            catch (Exception e) {
                errorMessage = "Could not successfully perform the 'doLogout' procedure due to an internal error.";
                LOGGER.error(errorMessage, (Throwable)e);
            }
        }
        return sessionToken;
    }

    public void handleRefreshFailure(String accessToken, String refreshToken, OAuth2Configuration configuration) {
        LOGGER.info("Unable to refresh token after max retries. Clearing session and redirecting to login.");
        this.doLogout(null);
        try {
            if (configuration != null && configuration.getProvider() != null) {
                String redirectUrl = "../../openid/" + configuration.getProvider().toLowerCase() + "/login";
                this.getResponse().sendRedirect(redirectUrl);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while sending redirect to login service: ", (Throwable)e);
            throw new RuntimeException("Failed to redirect to login", e);
        }
    }

    private static HttpHeaders getHttpHeaders(String accessToken, OAuth2Configuration configuration) {
        HttpHeaders headers = new HttpHeaders();
        if (configuration != null && configuration.getClientId() != null && configuration.getClientSecret() != null) {
            headers.setBasicAuth(configuration.getClientId(), configuration.getClientSecret());
        } else if (accessToken != null && !accessToken.isEmpty()) {
            headers.set("Authorization", "Bearer " + accessToken);
        }
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return headers;
    }

    private SessionToken sessionToken(String accessToken, String refreshToken, Date expires) {
        SessionToken sessionToken = new SessionToken();
        if (expires != null) {
            sessionToken.setExpires(Long.valueOf(expires.getTime()));
        }
        sessionToken.setAccessToken(accessToken);
        sessionToken.setRefreshToken(refreshToken);
        sessionToken.setTokenType("bearer");
        return sessionToken;
    }

    protected void updateAuthToken(String oldToken, OAuth2AccessToken newToken, OAuth2RefreshToken refreshToken, OAuth2Configuration conf) {
        Authentication authentication = this.cache().get(oldToken);
        if (authentication == null) {
            authentication = SecurityContextHolder.getContext().getAuthentication();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Updating the cache and the SecurityContext with new Auth details");
        }
        if (authentication != null && !(authentication instanceof AnonymousAuthenticationToken)) {
            TokenDetails details = this.getTokenDetails(authentication);
            String idToken = details.getIdToken();
            this.cache().removeEntry(oldToken);
            PreAuthenticatedAuthenticationToken updated = new PreAuthenticatedAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), authentication.getAuthorities());
            DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken(newToken);
            if (refreshToken != null) {
                accessToken.setRefreshToken(refreshToken);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating new details. AccessToken: {} IdToken: {}", (Object)accessToken, (Object)idToken);
            }
            updated.setDetails((Object)new TokenDetails((OAuth2AccessToken)accessToken, idToken, conf.getBeanName()));
            this.cache().putCacheEntry(newToken.getValue(), (Authentication)updated);
            SecurityContextHolder.getContext().setAuthentication((Authentication)updated);
        }
    }

    protected TokenDetails getTokenDetails(Authentication authentication) {
        return OAuth2Utils.getTokenDetails(authentication);
    }

    protected OAuth2AccessToken retrieveAccessToken(String accessToken, Long expires) {
        OAuth2ClientContext context;
        OAuth2RestTemplate oAuth2RestTemplate;
        Authentication authentication = this.cache() != null ? this.cache().get(accessToken) : null;
        OAuth2AccessToken result = null;
        if (authentication != null) {
            TokenDetails details = OAuth2Utils.getTokenDetails(authentication);
            result = details.getAccessToken();
        }
        if (result == null && (oAuth2RestTemplate = this.restTemplate()) != null && (context = oAuth2RestTemplate.getOAuth2ClientContext()) != null) {
            result = context.getAccessToken();
        }
        if (result == null) {
            result = new DefaultOAuth2AccessToken(accessToken);
            if (expires != null && expires > 0L) {
                ((DefaultOAuth2AccessToken)result).setExpiration(new Date(expires));
            }
        }
        return result;
    }

    protected HttpServletRequest getRequest() {
        return OAuth2Utils.getRequest();
    }

    protected HttpServletResponse getResponse() {
        return OAuth2Utils.getResponse();
    }

    public void doLogout(String sessionId) {
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        OAuth2RestTemplate restTemplate = this.restTemplate();
        OAuth2Configuration configuration = this.configuration();
        if (request == null || response == null || configuration == null) {
            LOGGER.warn("Request, response, or configuration is null, unable to proceed with logout.");
            return;
        }
        String token = null;
        String accessToken = null;
        if (sessionId != null) {
            TokenAuthenticationCache cache = this.cache();
            Authentication authentication = cache.get(sessionId);
            TokenDetails tokenDetails = this.getTokenDetails(authentication);
            if (tokenDetails != null) {
                token = tokenDetails.getIdToken();
                accessToken = tokenDetails.getAccessToken().getValue();
            }
            cache.removeEntry(sessionId);
        }
        if (token == null) {
            if (restTemplate != null && restTemplate.getOAuth2ClientContext() != null && restTemplate.getOAuth2ClientContext().getAccessToken() != null) {
                token = restTemplate.getOAuth2ClientContext().getAccessToken().getRefreshToken().getValue();
            }
            if (token == null) {
                token = OAuth2Utils.getParameterValue("refresh_token", request);
            }
            if (token == null) {
                token = (String)Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).getAttribute("refresh_token", 0);
            }
        }
        if (accessToken == null) {
            if (restTemplate != null && restTemplate.getOAuth2ClientContext() != null && restTemplate.getOAuth2ClientContext().getAccessToken() != null) {
                accessToken = restTemplate.getOAuth2ClientContext().getAccessToken().getValue();
            }
            if (accessToken == null) {
                accessToken = OAuth2Utils.getParameterValue("access_token", request);
            }
            if (accessToken == null) {
                accessToken = (String)Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).getAttribute("access_token", 0);
            }
        }
        if (configuration.isEnabled()) {
            if (token != null && accessToken != null && !token.isEmpty() && !accessToken.isEmpty()) {
                if (configuration.isGlobalLogoutEnabled()) {
                    this.doLogoutInternal(token, configuration, accessToken);
                }
                if (configuration.getRevokeEndpoint() != null) {
                    this.clearSession(restTemplate, request);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.info("Unable to retrieve access token. Remote logout was not executed.");
            }
            if (response != null) {
                this.clearCookies(request, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSession(OAuth2RestTemplate restTemplate, HttpServletRequest request) {
        AccessTokenRequest accessTokenRequest = restTemplate.getOAuth2ClientContext().getAccessTokenRequest();
        if (accessTokenRequest != null && accessTokenRequest.getStateKey() != null) {
            restTemplate.getOAuth2ClientContext().removePreservedState(accessTokenRequest.getStateKey());
        }
        try {
            if (accessTokenRequest != null) {
                accessTokenRequest.remove((Object)"access_token");
                accessTokenRequest.remove((Object)"refresh_token");
            }
            request.logout();
        }
        catch (ServletException e) {
            LOGGER.error("Error happened while doing request logout: ", (Throwable)e);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    protected void doLogoutInternal(Object token, OAuth2Configuration configuration, String accessToken) {
        String tokenValue = null;
        if (token instanceof OAuth2AccessToken) {
            tokenValue = ((OAuth2AccessToken)token).getRefreshToken() != null ? ((OAuth2AccessToken)token).getRefreshToken().getValue() : ((OAuth2AccessToken)token).getValue();
        } else if (token instanceof String) {
            tokenValue = (String)token;
        }
        if (configuration.getRevokeEndpoint() != null && tokenValue != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info("Performing remote logout");
            }
            this.callRevokeEndpoint(tokenValue, accessToken);
            this.callRemoteLogout(tokenValue, accessToken);
        }
    }

    protected void callRevokeEndpoint(String token, String accessToken) {
        OAuth2Configuration.Endpoint revokeEndpoint;
        OAuth2Configuration configuration = this.configuration();
        if (configuration != null && configuration.isEnabled() && (revokeEndpoint = configuration.buildRevokeEndpoint(token, accessToken, configuration)) != null) {
            RestTemplate template = new RestTemplate();
            try {
                ResponseEntity responseEntity = template.exchange(revokeEndpoint.getUrl(), revokeEndpoint.getMethod(), revokeEndpoint.getRequestEntity(), String.class, new Object[0]);
                if (responseEntity.getStatusCode().value() != 200) {
                    OAuth2SessionServiceDelegate.logRevokeErrors(responseEntity.getBody());
                }
            }
            catch (Exception e) {
                OAuth2SessionServiceDelegate.logRevokeErrors(e);
            }
        }
    }

    protected void callRemoteLogout(String token, String accessToken) {
        RestTemplate template;
        ResponseEntity responseEntity;
        OAuth2Configuration.Endpoint logoutEndpoint;
        OAuth2Configuration configuration = this.configuration();
        if (configuration != null && configuration.isEnabled() && (logoutEndpoint = configuration.buildLogoutEndpoint(token, accessToken, configuration)) != null && (responseEntity = (template = new RestTemplate()).exchange(logoutEndpoint.getUrl(), logoutEndpoint.getMethod(), logoutEndpoint.getRequestEntity(), String.class, new Object[0])).getStatusCode().value() != 200) {
            OAuth2SessionServiceDelegate.logRevokeErrors(responseEntity.getBody());
        }
    }

    protected void clearCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] allCookies = request.getCookies();
        if (allCookies != null) {
            for (Cookie toDelete : allCookies) {
                if (!this.deleteCookie(toDelete)) continue;
                toDelete.setMaxAge(-1);
                toDelete.setPath("/");
                toDelete.setComment("EXPIRING COOKIE at " + System.currentTimeMillis());
                response.addCookie(toDelete);
            }
        }
    }

    protected boolean deleteCookie(Cookie c) {
        return c.getName().equalsIgnoreCase("JSESSIONID") || c.getName().equalsIgnoreCase("access_token") || c.getName().equalsIgnoreCase("refresh_token");
    }

    protected TokenAuthenticationCache cache() {
        return GeoStoreContext.bean("oAuth2Cache", TokenAuthenticationCache.class);
    }

    protected OAuth2Configuration configuration() {
        Map<String, OAuth2Configuration> configurations = GeoStoreContext.beans(OAuth2Configuration.class);
        if (configurations != null) {
            Optional<OAuth2Configuration> enabledConfig = configurations.values().stream().filter(IdPConfiguration::isEnabled).findFirst();
            if (enabledConfig.isPresent()) {
                return enabledConfig.get();
            }
        } else {
            LOGGER.error("OAuth2Configuration is not initialized properly.");
            throw new IllegalStateException("Configuration is required but not initialized.");
        }
        return null;
    }

    protected HttpMessageConverterExtractor<OAuth2AccessToken> tokenExtractor() {
        return new HttpMessageConverterExtractor(OAuth2AccessToken.class, this.restTemplate().getMessageConverters());
    }

    protected abstract OAuth2RestTemplate restTemplate();

    public User getUser(String sessionId, boolean refresh, boolean autorefresh) {
        String username = this.getUserName(sessionId, refresh, autorefresh);
        if (username != null) {
            User user;
            try {
                user = this.userService.get(username);
            }
            catch (Exception e) {
                LOGGER.warn("Issue while retrieving user. Will return just the username.", (Throwable)e);
                user = new User();
                user.setName(username);
            }
            return user;
        }
        return null;
    }

    public String getUserName(String sessionId, boolean refresh, boolean autorefresh) {
        Object o;
        TokenAuthenticationCache cache = this.cache();
        Authentication authentication = cache.get(sessionId);
        if (refresh) {
            LOGGER.warn("Refresh was set to true but this delegate is not supporting refreshing token when retrieving the user...");
        }
        if (authentication != null && (o = authentication.getPrincipal()) != null) {
            return SecurityUtils.getUsername((Object)o);
        }
        return null;
    }

    private static void logRevokeErrors(Object cause) {
        LOGGER.error("Error while revoking authorization. Error is: {}", cause);
    }
}

