/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.core.security.password.SecurityUtils;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenDetails;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.authentication.BearerTokenExtractor;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OAuth2Utils {
    public static final String ID_TOKEN_PARAM = "id_token";
    public static final String ACCESS_TOKEN_PARAM = "access_token";
    public static final String REFRESH_TOKEN_PARAM = "refresh_token";
    public static final String TOKENS_KEY = "tokens_key";
    public static final String AUTH_PROVIDER = "authProvider";

    public static String tokenFromParamsOrBearer(String paramName, HttpServletRequest request) {
        String token = OAuth2Utils.getParameterValue(paramName, request);
        if (token == null) {
            token = OAuth2Utils.getBearerToken(request);
        }
        return token;
    }

    public static Date fiveMinutesFromNow() {
        Calendar currentTimeNow = Calendar.getInstance();
        currentTimeNow.add(12, 5);
        return currentTimeNow.getTime();
    }

    public static String getParameterValue(String paramName, HttpServletRequest request) {
        Enumeration iterator = request.getParameterNames();
        while (iterator.hasMoreElements()) {
            String param = (String)iterator.nextElement();
            if (!paramName.equalsIgnoreCase(param)) continue;
            return request.getParameter(param);
        }
        return null;
    }

    public static String getBearerToken(HttpServletRequest request) {
        Authentication auth = new BearerTokenExtractor().extract(request);
        if (auth != null) {
            return SecurityUtils.getUsername((Object)auth.getPrincipal());
        }
        return null;
    }

    public static String getRequestAttribute(String name) {
        String token = (String)RequestContextHolder.getRequestAttributes().getAttribute(name, 0);
        if (token == null) {
            token = (String)RequestContextHolder.getRequestAttributes().getAttribute(name, 1);
        }
        return token;
    }

    public static String getIdToken() {
        return OAuth2Utils.getRequestAttribute("OpenIdConnect-IdTokenValue");
    }

    public static String getAccessToken() {
        String token = OAuth2Utils.getRequestAttribute(ACCESS_TOKEN_PARAM);
        if (token == null) {
            token = OAuth2Utils.tokenFromParamsOrBearer(ACCESS_TOKEN_PARAM, OAuth2Utils.getRequest());
        }
        return token;
    }

    public static String getRefreshAccessToken() {
        String refreshToken = OAuth2Utils.getRequestAttribute(REFRESH_TOKEN_PARAM);
        if (refreshToken == null) {
            refreshToken = OAuth2Utils.getParameterValue(REFRESH_TOKEN_PARAM, OAuth2Utils.getRequest());
        }
        return refreshToken;
    }

    public static TokenDetails getTokenDetails(Authentication authentication) {
        Object details;
        TokenDetails tokenDetails = null;
        if (authentication != null && (details = authentication.getDetails()) instanceof TokenDetails) {
            tokenDetails = (TokenDetails)details;
        }
        return tokenDetails;
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
    }
}

