/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.utils;

import it.geosolutions.geostore.services.rest.utils.DataURIDecoder;
import org.junit.Assert;
import org.junit.Test;

public class DataURIDecoderTest {
    @Test
    public void testInvalid() {
        DataURIDecoder dud = new DataURIDecoder("this is no data");
        Assert.assertFalse((boolean)dud.isValid());
    }

    @Test
    public void testBase() {
        DataURIDecoder dud = new DataURIDecoder("data:");
        Assert.assertTrue((boolean)dud.isValid());
        Assert.assertNull((Object)dud.getMediatype());
        Assert.assertNull((Object)dud.getCharset());
        Assert.assertNull((Object)dud.getEncoding());
        Assert.assertFalse((boolean)dud.isBase64Encoded());
        Assert.assertEquals((Object)"text/plain", (Object)dud.getNormalizedMediatype());
    }

    @Test
    public void testMime() {
        DataURIDecoder dud = new DataURIDecoder("data:qwe/asd;");
        Assert.assertTrue((boolean)dud.isValid());
        Assert.assertEquals((Object)"qwe/asd", (Object)dud.getMediatype());
        Assert.assertNull((Object)dud.getCharset());
        Assert.assertNull((Object)dud.getEncoding());
        Assert.assertFalse((boolean)dud.isBase64Encoded());
        Assert.assertEquals((Object)"qwe/asd", (Object)dud.getNormalizedMediatype());
    }

    @Test
    public void testMimeBase64() {
        DataURIDecoder dud = new DataURIDecoder("data:qwe/asd;base64");
        Assert.assertTrue((boolean)dud.isValid());
        Assert.assertEquals((Object)"qwe/asd", (Object)dud.getMediatype());
        Assert.assertNull((Object)dud.getCharset());
        Assert.assertEquals((Object)"base64", (Object)dud.getEncoding());
        Assert.assertTrue((boolean)dud.isBase64Encoded());
        Assert.assertEquals((Object)"qwe/asd", (Object)dud.getNormalizedMediatype());
    }

    @Test
    public void testMimeCharsetBase64() {
        DataURIDecoder dud = new DataURIDecoder("data:qwe/asd;charset=foo;base64");
        Assert.assertTrue((boolean)dud.isValid());
        Assert.assertEquals((Object)"qwe/asd", (Object)dud.getMediatype());
        Assert.assertEquals((Object)"foo", (Object)dud.getCharset());
        Assert.assertEquals((Object)"base64", (Object)dud.getEncoding());
        Assert.assertTrue((boolean)dud.isBase64Encoded());
        Assert.assertEquals((Object)"qwe/asd", (Object)dud.getNormalizedMediatype());
    }
}

