/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.InMemoryUserSessionServiceImpl;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.UserSessionService;
import it.geosolutions.geostore.services.dto.UserSession;
import it.geosolutions.geostore.services.dto.UserSessionImpl;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.SessionTokenAuthenticationFilter;
import it.geosolutions.geostore.services.rest.utils.MockedUserService;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SessionTokenAuthenticationFilterTest {
    private static final String DEFAULT_PREFIX = "Bearer ";
    private static final String DEFAULT_HEADER = "Authorization";
    private static final String SAMPLE_USER = "user";
    private static final String SAMPLE_TOKEN = UUID.randomUUID().toString();
    private static final String WRONG_TOKEN = UUID.randomUUID().toString();
    private static final Authentication SAMPLE_AUTH = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"");
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    FilterChain chain = null;
    private SessionTokenAuthenticationFilter filter;
    private Map<String, Authentication> tokens;

    @Before
    public void setUp() {
        this.tokens = new HashMap<String, Authentication>();
        this.tokens.put(SAMPLE_TOKEN, SAMPLE_AUTH);
        this.filter = new SessionTokenAuthenticationFilter();
        this.filter.setUserService((UserService)new MockedUserService());
        this.filter.setUserSessionService((UserSessionService)new InMemoryUserSessionServiceImpl());
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.chain = (FilterChain)Mockito.mock(FilterChain.class);
    }

    @After
    public void tearDown() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @Test
    public void userWorksWithNameOnlyTest() throws IOException, ServletException, BadRequestServiceEx, NotFoundServiceEx {
        User user = new User();
        user.setName(SAMPLE_USER);
        user.setRole(Role.USER);
        this.filter.setCacheExpiration(1);
        User sessionUser = new User();
        sessionUser.setName(SAMPLE_USER);
        sessionUser.setRole(Role.USER);
        this.filter.getUserService().insert(user);
        Mockito.when((Object)this.request.getHeader(DEFAULT_HEADER)).thenReturn((Object)(DEFAULT_PREFIX + SAMPLE_TOKEN));
        GregorianCalendar expires = new GregorianCalendar();
        ((Calendar)expires).add(13, 1296000);
        this.filter.getUserSessionService().registerNewSession(SAMPLE_TOKEN, (UserSession)new UserSessionImpl(sessionUser, (Calendar)expires));
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        User authUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Assert.assertEquals((Object)SAMPLE_USER, (Object)authUser.getName());
        Assert.assertNotNull((Object)authUser.getId());
    }

    @Test
    public void userWorksWithFakeIdTest() throws IOException, ServletException, BadRequestServiceEx, NotFoundServiceEx {
        User user = new User();
        user.setName(SAMPLE_USER);
        user.setRole(Role.USER);
        this.filter.setCacheExpiration(1);
        User sessionUser = new User();
        sessionUser.setId(Long.valueOf(-1L));
        sessionUser.setName(SAMPLE_USER);
        sessionUser.setRole(Role.USER);
        this.filter.getUserService().insert(user);
        Mockito.when((Object)this.request.getHeader(DEFAULT_HEADER)).thenReturn((Object)(DEFAULT_PREFIX + SAMPLE_TOKEN));
        GregorianCalendar expires = new GregorianCalendar();
        ((Calendar)expires).add(13, 1296000);
        this.filter.getUserSessionService().registerNewSession(SAMPLE_TOKEN, (UserSession)new UserSessionImpl(sessionUser, (Calendar)expires));
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        User authUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Assert.assertEquals((Object)SAMPLE_USER, (Object)authUser.getName());
        Assert.assertNotNull((Object)authUser.getId());
    }
}

