/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.GrantedAuthoritiesMapper;
import it.geosolutions.geostore.services.rest.security.GeoStoreAuthenticationFilter;
import it.geosolutions.geostore.services.rest.utils.GroupMapper;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class HeadersAuthenticationFilter
extends GeoStoreAuthenticationFilter {
    public static final String DEFAULT_USERNAME_HEADER = "x-geostore-user";
    public static final String DEFAULT_GROUPS_HEADER = "x-geostore-groups";
    public static final String DEFAULT_ROLE_HEADER = "x-geostore-role";
    private String usernameHeader = "x-geostore-user";
    private String groupsHeader = "x-geostore-groups";
    private String roleHeader = "x-geostore-role";
    private String listDelimiter = ",";
    private String defaultRole = "USER";
    private boolean addEveryOneGroup = false;
    private GrantedAuthoritiesMapper authoritiesMapper;
    private GroupMapper groupMapper = null;

    @Override
    protected void authenticate(HttpServletRequest req) {
        String username = req.getHeader(this.usernameHeader);
        if (username != null) {
            User user = new User();
            user.setId(Long.valueOf(-1L));
            user.setTrusted(true);
            user.setName(username);
            user.setRole(this.getUserRole(this.defaultRole));
            String groups = req.getHeader(this.groupsHeader);
            HashSet<SimpleGrantedAuthority> groupAuthorities = new HashSet<SimpleGrantedAuthority>();
            user.setGroups(new HashSet());
            boolean everyoneFound = false;
            long groupCounter = 1L;
            if (groups != null) {
                String[] groupsList;
                for (String groupName : groupsList = groups.split(this.listDelimiter)) {
                    if (groupName.equals(GroupReservedNames.EVERYONE.groupName())) {
                        everyoneFound = true;
                    }
                    if (this.groupMapper != null) {
                        groupName = this.groupMapper.transform(groupName);
                    }
                    UserGroup group = new UserGroup();
                    group.setGroupName(groupName);
                    group.setId(Long.valueOf(groupCounter++));
                    group.setEnabled(true);
                    user.getGroups().add(group);
                    groupAuthorities.add(new SimpleGrantedAuthority(groupName));
                }
            }
            if (!everyoneFound && this.addEveryOneGroup) {
                UserGroup group = new UserGroup();
                group.setGroupName(GroupReservedNames.EVERYONE.groupName());
                group.setId(Long.valueOf(groupCounter++));
                group.setEnabled(true);
                user.getGroups().add(group);
                groupAuthorities.add(new SimpleGrantedAuthority(GroupReservedNames.EVERYONE.groupName()));
            }
            HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
            String role = req.getHeader(this.roleHeader);
            if (role != null) {
                user.setRole(this.getUserRole(role));
                authorities.add(this.createRole(role));
            } else if (this.authoritiesMapper != null) {
                Role chosenRole = user.getRole();
                for (GrantedAuthority authority : this.authoritiesMapper.mapAuthorities(groupAuthorities)) {
                    authorities.add(this.createRole(authority.getAuthority()));
                    Role userRole = this.getUserRole(authority.getAuthority());
                    chosenRole = this.morePrivileged(userRole, chosenRole);
                }
                user.setRole(chosenRole);
                authorities.add(this.createRole(user.getRole().name()));
            } else {
                authorities.add(this.createRole(user.getRole().name()));
            }
            PreAuthenticatedAuthenticationToken auth = new PreAuthenticatedAuthenticationToken((Object)user, (Object)"", authorities);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        }
    }

    private Role morePrivileged(Role role1, Role role2) {
        if (role1.equals((Object)Role.ADMIN) || role2.equals((Object)Role.ADMIN)) {
            return Role.ADMIN;
        }
        if (role1.equals((Object)Role.USER) || role2.equals((Object)Role.USER)) {
            return Role.USER;
        }
        return Role.GUEST;
    }

    private SimpleGrantedAuthority createRole(String role) {
        return new SimpleGrantedAuthority("ROLE_" + role);
    }

    private Role getUserRole(String role) {
        if ("USER".equalsIgnoreCase(role)) {
            return Role.USER;
        }
        if ("ADMIN".equalsIgnoreCase(role)) {
            return Role.ADMIN;
        }
        if ("GUEST".equalsIgnoreCase(role)) {
            return Role.GUEST;
        }
        return this.getUserRole(this.defaultRole);
    }

    public String getUsernameHeader() {
        return this.usernameHeader;
    }

    public void setUsernameHeader(String usernameHeader) {
        this.usernameHeader = usernameHeader;
    }

    public String getGroupsHeader() {
        return this.groupsHeader;
    }

    public void setGroupsHeader(String groupsHeader) {
        this.groupsHeader = groupsHeader;
    }

    public String getRoleHeader() {
        return this.roleHeader;
    }

    public void setRoleHeader(String roleHeader) {
        this.roleHeader = roleHeader;
    }

    public String getListDelimiter() {
        return this.listDelimiter;
    }

    public void setListDelimiter(String listDelimiter) {
        this.listDelimiter = listDelimiter;
    }

    public String getDefaultRole() {
        return this.defaultRole;
    }

    public void setDefaultRole(String defaultRole) {
        this.defaultRole = defaultRole;
    }

    public GrantedAuthoritiesMapper getAuthoritiesMapper() {
        return this.authoritiesMapper;
    }

    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        this.authoritiesMapper = authoritiesMapper;
    }

    public boolean isAddEveryOneGroup() {
        return this.addEveryOneGroup;
    }

    public void setAddEveryOneGroup(boolean addEveryOneGroup) {
        this.addEveryOneGroup = addEveryOneGroup;
    }

    public GroupMapper getGroupMapper() {
        return this.groupMapper;
    }

    public void setGroupMapper(GroupMapper groupMapper) {
        this.groupMapper = groupMapper;
    }
}

