/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.ldap.IterableNamingEnumeration;
import it.geosolutions.geostore.core.ldap.MockContextSource;
import it.geosolutions.geostore.core.security.GrantedAuthoritiesMapper;
import it.geosolutions.geostore.core.security.SimpleGrantedAuthoritiesMapper;
import it.geosolutions.geostore.services.rest.security.GeoStoreLdapAuthoritiesPopulator;
import it.geosolutions.geostore.services.rest.security.MockDirContextOperations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.security.core.GrantedAuthority;

public class GeoStoreLdapAuthoritiesPopulatorTest {
    DirContext ctx = new DirContextAdapter(){

        public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
            if ("ou=groups".equals(name)) {
                if ("(member=uid=bill,ou=people)".equals(filter)) {
                    ArrayList groups = new ArrayList();
                    SearchResult sr = new SearchResult("cn=group1", null, (Object)new MockDirContextOperations(){

                        @Override
                        public String getNameInNamespace() {
                            return "cn=group1,ou=groups";
                        }

                        @Override
                        public String getStringAttribute(String name) {
                            if ("cn".equals(name)) {
                                return "group1";
                            }
                            return "";
                        }
                    }, new BasicAttributes());
                    SearchResult sr2 = new SearchResult("cn=group2", null, (Object)new MockDirContextOperations(){

                        @Override
                        public String getNameInNamespace() {
                            return "cn=group2,ou=groups";
                        }

                        @Override
                        public String getStringAttribute(String name) {
                            if ("cn".equals(name)) {
                                return "group2";
                            }
                            return "";
                        }
                    }, new BasicAttributes());
                    return new IterableNamingEnumeration(Arrays.asList(sr, sr2));
                }
                if ("(member=cn=group1,ou=groups)".equals(filter)) {
                    ArrayList groups = new ArrayList();
                    SearchResult sr = new SearchResult("cn=parentgroup1", null, (Object)new MockDirContextOperations(){

                        @Override
                        public String getNameInNamespace() {
                            return "cn=parentgroup1,ou=groups";
                        }

                        @Override
                        public String getStringAttribute(String name) {
                            if ("cn".equals(name)) {
                                return "parentgroup1";
                            }
                            return "";
                        }
                    }, new BasicAttributes());
                    return new IterableNamingEnumeration(Collections.singletonList(sr));
                }
            }
            return new IterableNamingEnumeration((Iterable)Collections.EMPTY_LIST);
        }
    };

    @Test
    public void testNestedGroupsEnabled() {
        GeoStoreLdapAuthoritiesPopulator authoritiesPopulator = new GeoStoreLdapAuthoritiesPopulator((ContextSource)new MockContextSource(this.ctx), "ou=groups", "ou=roles");
        authoritiesPopulator.setEnableHierarchicalGroups(true);
        Set authorities = authoritiesPopulator.getGroupMembershipRoles("uid=bill,ou=people", "bill");
        Assert.assertEquals((long)3L, (long)authorities.size());
    }

    @Test
    public void testNestedGroupsDisabled() {
        GeoStoreLdapAuthoritiesPopulator authoritiesPopulator = new GeoStoreLdapAuthoritiesPopulator((ContextSource)new MockContextSource(this.ctx), "ou=groups", "ou=roles");
        authoritiesPopulator.setEnableHierarchicalGroups(false);
        Set authorities = authoritiesPopulator.getGroupMembershipRoles("uid=bill,ou=people", "bill");
        Assert.assertEquals((long)2L, (long)authorities.size());
    }

    @Test
    public void testDropUnmappedRoles() {
        GeoStoreLdapAuthoritiesPopulator authoritiesPopulator = new GeoStoreLdapAuthoritiesPopulator((ContextSource)new MockContextSource(this.ctx), "ou=groups", "ou=groups");
        authoritiesPopulator.setEnableHierarchicalGroups(false);
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("ROLE_GROUP2", "ROLE_ADMIN");
        SimpleGrantedAuthoritiesMapper mapper = new SimpleGrantedAuthoritiesMapper(mappings);
        mapper.setDropUnmapped(true);
        authoritiesPopulator.setRoleMapper((GrantedAuthoritiesMapper)mapper);
        Set authorities = authoritiesPopulator.getGroupMembershipRoles("uid=bill,ou=people", "bill");
        List<String> expected = Arrays.asList("ROLE_ADMIN", "GROUP1", "GROUP2");
        List stringAuthorities = authorities.stream().map(a -> a.getAuthority()).collect(Collectors.toList());
        Assert.assertEquals((long)expected.size(), (long)stringAuthorities.size());
        Assert.assertTrue((boolean)stringAuthorities.containsAll(expected));
    }

    @Test
    public void testDropUnmappedGroups() {
        GeoStoreLdapAuthoritiesPopulator authoritiesPopulator = new GeoStoreLdapAuthoritiesPopulator((ContextSource)new MockContextSource(this.ctx), "ou=groups", "ou=roles");
        authoritiesPopulator.setEnableHierarchicalGroups(false);
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("GROUP2", "MAPPED_GROUP");
        SimpleGrantedAuthoritiesMapper mapper = new SimpleGrantedAuthoritiesMapper(mappings);
        mapper.setDropUnmapped(true);
        authoritiesPopulator.setGroupMapper((GrantedAuthoritiesMapper)mapper);
        Set authorities = authoritiesPopulator.getGroupMembershipRoles("uid=bill,ou=people", "bill");
        Assert.assertEquals((long)1L, (long)authorities.size());
        Assert.assertEquals((Object)"MAPPED_GROUP", (Object)((GrantedAuthority)authorities.iterator().next()).getAuthority());
    }
}

