/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import java.util.Calendar;
import java.util.Date;

public class KeycloakTokenDetails {
    private final Date expiration;
    private String accessToken;
    private String idToken;
    private String refreshToken;

    public KeycloakTokenDetails(String accessToken, String refreshToken, Long exp) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        Date epoch = new Date(0L);
        this.expiration = this.expirationDate(epoch, exp.intValue());
    }

    public KeycloakTokenDetails(String accessToken, String refreshToken, long expIn) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        Date start = new Date();
        this.expiration = this.expirationDate(start, Long.valueOf(expIn).intValue());
    }

    private Date expirationDate(Date start, int toAdd) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(13, toAdd);
        return calendar.getTime();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }
}

