/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.Serializable;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class TokenDetails
implements Serializable {
    private final String idToken;
    private final String provider;
    private OAuth2AccessToken accessToken;
    private DecodedJWT decodedJWT;

    public TokenDetails(OAuth2AccessToken accessToken, String idToken, String provider) {
        this.idToken = idToken;
        this.accessToken = accessToken;
        if (idToken != null) {
            this.decodedJWT = JWT.decode((String)idToken);
        }
        this.provider = provider;
    }

    public <T> T getClaim(String claimName, Class<T> binding) {
        Claim claim;
        Object result = null;
        if (this.decodedJWT != null && (claim = this.decodedJWT.getClaim(claimName)) != null) {
            result = claim.as(binding);
        }
        return (T)result;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public OAuth2AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(OAuth2AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public String getProvider() {
        return this.provider;
    }
}

