/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.IPRange;
import it.geosolutions.geostore.services.IPRangeService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.RESTIPRangeService;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.IPRangeList;
import it.geosolutions.geostore.services.rest.model.RESTIPRange;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RESTIPRangeServiceImpl
implements RESTIPRangeService {
    private static final Logger LOGGER = LogManager.getLogger(RESTIPRangeServiceImpl.class);
    private IPRangeService ipRangeService;

    public void setIpRangeService(IPRangeService ipRangeService) {
        this.ipRangeService = ipRangeService;
    }

    public long insert(SecurityContext sc, RESTIPRange ipRange) throws BadRequestServiceEx {
        try {
            if (ipRange == null) {
                throw new BadRequestWebEx("IP range is null");
            }
            if (ipRange.getId() != null) {
                throw new BadRequestWebEx("Id should be null");
            }
            return this.ipRangeService.insert(ipRange.toIPRange());
        }
        catch (BadRequestServiceEx e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BadRequestWebEx(e.getMessage());
        }
    }

    public IPRangeList getAll(SecurityContext sc) throws BadRequestWebEx {
        try {
            List ipRanges = this.ipRangeService.getAll();
            long count = 0L;
            if (!ipRanges.isEmpty()) {
                count = this.ipRangeService.count();
            }
            return new IPRangeList((Collection)ipRanges.stream().map(RESTIPRange::new).collect(Collectors.toList()), Long.valueOf(count));
        }
        catch (BadRequestServiceEx e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BadRequestWebEx(e.getMessage());
        }
    }

    public RESTIPRange get(SecurityContext sc, long id) throws NotFoundWebEx {
        IPRange ipRange = this.ipRangeService.get(id);
        if (ipRange == null) {
            throw new NotFoundWebEx("IP range not found");
        }
        return new RESTIPRange(ipRange);
    }

    public long update(SecurityContext sc, long id, RESTIPRange ipRange) {
        try {
            return this.ipRangeService.update(id, ipRange.toIPRange());
        }
        catch (BadRequestServiceEx e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BadRequestWebEx(e.getMessage());
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
    }

    public void delete(SecurityContext sc, long id) throws NotFoundWebEx {
        try {
            this.ipRangeService.delete(id);
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
    }
}

