/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.StoredData;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.StoredDataService;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.RESTStoredDataService;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.ForbiddenErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.InternalErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.impl.RESTServiceImpl;
import it.geosolutions.geostore.services.rest.model.enums.RawFormat;
import it.geosolutions.geostore.services.rest.utils.DataURIDecoder;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.xml.XMLSerializer;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RESTStoredDataServiceImpl
extends RESTServiceImpl
implements RESTStoredDataService {
    private static final Logger LOGGER = LogManager.getLogger(RESTStoredDataServiceImpl.class);
    private static final Collection<MediaType> GET_XML_MEDIA_TYPES = Arrays.asList(MediaType.TEXT_XML_TYPE, MediaType.APPLICATION_XML_TYPE);
    private static final Collection<MediaType> GET_JSON_MEDIA_TYPES = Collections.singletonList(MediaType.APPLICATION_JSON_TYPE);
    private static final Collection<MediaType> GET_TEXT_MEDIA_TYPES = Collections.singletonList(MediaType.TEXT_PLAIN_TYPE);
    private StoredDataService storedDataService;

    public void setStoredDataService(StoredDataService storedDataService) {
        this.storedDataService = storedDataService;
    }

    public long update(SecurityContext sc, long id, String data) throws NotFoundWebEx {
        try {
            if (data == null) {
                throw new BadRequestWebEx("Data is null");
            }
            boolean canUpdate = false;
            User authUser = this.extractAuthUser(sc);
            canUpdate = this.resourceAccessWrite(authUser, id);
            if (!canUpdate) {
                throw new ForbiddenErrorWebEx("This user cannot update or create this store !");
            }
            this.storedDataService.update(id, data);
            return id;
        }
        catch (NotFoundServiceEx ex) {
            LOGGER.warn("Data not found (" + id + "): " + ex.getMessage(), (Throwable)ex);
            throw new NotFoundWebEx("Data not found");
        }
    }

    public void delete(SecurityContext sc, long id) throws NotFoundWebEx {
        boolean canDelete = false;
        User authUser = this.extractAuthUser(sc);
        canDelete = this.resourceAccessWrite(authUser, id);
        if (canDelete) {
            boolean ret = this.storedDataService.delete(id);
            if (!ret) {
                throw new NotFoundWebEx("Data not found");
            }
        } else {
            throw new ForbiddenErrorWebEx("This user cannot delete this store !");
        }
    }

    public String get(SecurityContext sc, HttpHeaders headers, long id) throws NotFoundWebEx {
        String data;
        StoredData storedData;
        if (id == -1L) {
            return "dummy payload";
        }
        boolean canRead = false;
        User authUser = this.extractAuthUser(sc);
        canRead = this.resourceAccessRead(authUser, id);
        if (!canRead) {
            throw new ForbiddenErrorWebEx("This user cannot read this stored data !");
        }
        try {
            storedData = this.storedDataService.get(id);
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx("Data not found");
        }
        String string = data = storedData == null ? "" : storedData.getData();
        if (headers.getAcceptableMediaTypes().contains(MediaType.WILDCARD_TYPE)) {
            return data;
        }
        if (!Collections.disjoint(GET_TEXT_MEDIA_TYPES, headers.getAcceptableMediaTypes())) {
            return data;
        }
        if (!Collections.disjoint(GET_JSON_MEDIA_TYPES, headers.getAcceptableMediaTypes())) {
            return this.toJSON(data);
        }
        if (!Collections.disjoint(GET_XML_MEDIA_TYPES, headers.getAcceptableMediaTypes())) {
            return this.toXML(data);
        }
        throw new InternalErrorWebEx("Illegal state (" + String.valueOf(headers.getAcceptableMediaTypes()) + ")");
    }

    private String toJSON(String data) {
        try {
            XMLSerializer xmlSerializer = new XMLSerializer();
            JSON json = xmlSerializer.read(data);
            String ret = json.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transformed XML -> JSON");
            }
            return ret;
        }
        catch (JSONException exc) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Data is not in native XML format.");
            }
            try {
                JSONSerializer.toJSON((Object)data);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Data is in native JSON format.");
                }
                return data;
            }
            catch (JSONException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Data is not in native JSON format.");
                }
                JSONObject jsonObj = new JSONObject();
                jsonObj.put((Object)"data", (Object)data);
                String ret = jsonObj.toString();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Transformed plaintext -> JSON");
                }
                return ret;
            }
        }
    }

    private String toXML(String data) {
        StringReader reader = new StringReader(data);
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.build((Reader)reader);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Data is in native XML format.");
            }
            String string = data;
            reader.close();
            return string;
        }
        catch (Throwable builder) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {
                    builder.addSuppressed(throwable);
                }
                throw builder;
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Data is not in native XML format.", (Throwable)e);
                }
                try {
                    JSON json = JSONSerializer.toJSON((Object)data);
                    XMLSerializer xmlSerializer = new XMLSerializer();
                    String ret = xmlSerializer.write(json);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Transformed JSON -> XML");
                    }
                    return ret;
                }
                catch (JSONException exc) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Data is not in native JSON format.", (Throwable)exc);
                    }
                    Element element = new Element("data");
                    element.addContent(data);
                    XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
                    String ret = outputter.outputString(element);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Transformed plaintext -> XML");
                    }
                    return ret;
                }
            }
        }
    }

    public Response getRaw(SecurityContext sc, HttpHeaders headers, long id, String decodeFormat) throws NotFoundWebEx {
        StoredData storedData;
        if (id == -1L) {
            return Response.ok().entity((Object)"dummy payload").build();
        }
        try {
            storedData = this.storedDataService.get(id);
        }
        catch (NotFoundServiceEx e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (storedData == null) {
            return Response.noContent().build();
        }
        String data = storedData.getData();
        if (decodeFormat == null) {
            return Response.ok().entity((Object)data).build();
        }
        if (decodeFormat.equalsIgnoreCase(RawFormat.BASE64.name())) {
            byte[] decoded = Base64.decodeBase64((String)data);
            return Response.ok().entity((Object)decoded).build();
        }
        if (decodeFormat.equalsIgnoreCase(RawFormat.DATAURI.name())) {
            return this.decodeDataURI(data);
        }
        LOGGER.warn("Unknown decode format '" + decodeFormat + "'");
        return Response.ok().entity((Object)data).build();
    }

    private Response decodeDataURI(String data) {
        if (!data.startsWith("data:")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Not a data URI").build();
        }
        String[] split = data.split(",", 2);
        if (split.length < 2) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Bad data, comma is missing").build();
        }
        DataURIDecoder dud = new DataURIDecoder(split[0]);
        if (!dud.isValid()) {
            LOGGER.warn("Could not parse data URI '" + split[0] + "'");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Bad data URI").build();
        }
        if (dud.getCharset() != null) {
            LOGGER.warn("TODO: Charset '" + dud.getCharset() + "' should be handled.");
        }
        if (dud.getEncoding() != null && !dud.isBase64Encoded()) {
            LOGGER.warn("TODO: Encoding '" + dud.getEncoding() + "' should be handled.");
        }
        Object entity = dud.isBase64Encoded() ? (Object)Base64.decodeBase64((String)split[1]) : split[1];
        return Response.ok().type(dud.getNormalizedMediatype()).entity(entity).build();
    }

    private long parseId(String id) throws BadRequestWebEx {
        try {
            return Long.parseLong(id);
        }
        catch (Exception e) {
            LOGGER.info("Bad id requested '" + id + "'");
            throw new BadRequestWebEx("Bad id");
        }
    }
}

