/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2.openid_connect;

import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreOAuthRestTemplate;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2GeoStoreSecurityConfiguration;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.OpenIdConnectConfiguration;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.OpenIdConnectFilter;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.OpenIdConnectTokenServices;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.bearer.AudienceAccessTokenValidator;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.bearer.MultiTokenValidator;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.bearer.OpenIdTokenValidator;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.bearer.SubjectTokenValidator;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.enancher.ClientSecretRequestEnhancer;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.enancher.PKCERequestEnhancer;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenProviderChain;
import org.springframework.security.oauth2.client.token.DefaultRequestEnhancer;
import org.springframework.security.oauth2.client.token.RequestEnhancer;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordAccessTokenProvider;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.oauth2.provider.token.store.jwk.JwkTokenStore;

@Configuration(value="oidcSecConfig")
@EnableOAuth2Client
public class OpenIdConnectSecurityConfiguration
extends OAuth2GeoStoreSecurityConfiguration {
    static final String CONF_BEAN_NAME = "oidcOAuth2Config";
    private static final Logger LOGGER = LogManager.getLogger(OpenIdConnectSecurityConfiguration.class);

    @Override
    public OAuth2ProtectedResourceDetails resourceDetails() {
        AuthorizationCodeResourceDetails details = (AuthorizationCodeResourceDetails)super.resourceDetails();
        details.setTokenName("authorization_code");
        return details;
    }

    @Override
    @Bean(value={"oidcOAuth2Config"})
    public OAuth2Configuration configuration() {
        return new OpenIdConnectConfiguration();
    }

    @Override
    @Bean(value={"oidcOpenIdRestTemplate"})
    @Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    public GeoStoreOAuthRestTemplate oauth2RestTemplate() {
        GeoStoreOAuthRestTemplate oAuth2RestTemplate = this.restTemplate();
        this.setJacksonConverter(oAuth2RestTemplate);
        AuthorizationCodeAccessTokenProvider authorizationAccessTokenProvider = this.authorizationAccessTokenProvider();
        OpenIdConnectConfiguration idConfig = (OpenIdConnectConfiguration)this.configuration();
        if (idConfig.isUsePKCE()) {
            LOGGER.info("Using PKCE for OpenID Connect");
            authorizationAccessTokenProvider.setTokenRequestEnhancer((RequestEnhancer)new PKCERequestEnhancer(idConfig));
        } else if (idConfig.isSendClientSecret()) {
            LOGGER.info("Using client secret for OpenID Connect");
            authorizationAccessTokenProvider.setTokenRequestEnhancer((RequestEnhancer)new ClientSecretRequestEnhancer());
        } else {
            LOGGER.info("Using default request enhancer for OpenID Connect");
            authorizationAccessTokenProvider.setTokenRequestEnhancer((RequestEnhancer)new DefaultRequestEnhancer());
        }
        AccessTokenProviderChain accessTokenProviderChain = new AccessTokenProviderChain(Arrays.asList(authorizationAccessTokenProvider, new ImplicitAccessTokenProvider(), new ResourceOwnerPasswordAccessTokenProvider(), new ClientCredentialsAccessTokenProvider()));
        oAuth2RestTemplate.setAccessTokenProvider((AccessTokenProvider)accessTokenProviderChain);
        if (idConfig.getJwkURI() != null && !"".equals(idConfig.getJwkURI())) {
            LOGGER.info("Using JWK for OpenID Connect");
            oAuth2RestTemplate.setTokenStore(new JwkTokenStore(idConfig.getJwkURI()));
        }
        return oAuth2RestTemplate;
    }

    @Bean(name={"authorizationAccessTokenProvider"})
    @Scope(value="prototype")
    public AuthorizationCodeAccessTokenProvider authorizationAccessTokenProvider() {
        AuthorizationCodeAccessTokenProvider authorizationCodeAccessTokenProvider = new AuthorizationCodeAccessTokenProvider();
        authorizationCodeAccessTokenProvider.setStateMandatory(false);
        authorizationCodeAccessTokenProvider.setTokenRequestEnhancer((RequestEnhancer)new DefaultRequestEnhancer());
        return authorizationCodeAccessTokenProvider;
    }

    @Bean
    public OpenIdConnectFilter oidcOpenIdFilter() {
        return new OpenIdConnectFilter(this.oidcTokenServices(), this.oauth2RestTemplate(), this.configuration(), this.oAuth2Cache(), this.openIdConnectBearerTokenValidator());
    }

    @Bean
    public OpenIdTokenValidator openIdConnectBearerTokenValidator() {
        return new MultiTokenValidator(Arrays.asList(new AudienceAccessTokenValidator(), new SubjectTokenValidator()));
    }

    @Bean
    public OpenIdConnectTokenServices oidcTokenServices() {
        return new OpenIdConnectTokenServices(this.configuration().getPrincipalKey());
    }

    @Bean
    public TokenAuthenticationCache oAuth2Cache() {
        return new TokenAuthenticationCache();
    }
}

