/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.IPRange;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.rest.exception.ForbiddenErrorWebEx;
import it.geosolutions.geostore.services.rest.impl.RESTResourceServiceImpl;
import it.geosolutions.geostore.services.rest.model.RESTAttribute;
import it.geosolutions.geostore.services.rest.model.SecurityRuleList;
import it.geosolutions.geostore.services.rest.utils.MockSecurityContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.SecurityContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.web.context.request.RequestContextHolder;

public class RESTResourceServiceImplTest
extends ServiceTestBase {
    RESTResourceServiceImpl restResourceService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.restResourceService = new RESTResourceServiceImpl();
        this.restResourceService.setResourceService(resourceService);
        this.restResourceService.setResourcePermissionService(resourcePermissionService);
        this.mockHttpRequestIPAddressAttribute();
    }

    @After
    public void cleanup() {
        RequestContextHolder.resetRequestAttributes();
    }

    @Test
    public void testUpdateResource_editorUpdate() throws Exception {
        long u0ID = this.createUser("u0", Role.USER, "p0");
        User user = new User();
        user.setId(Long.valueOf(u0ID));
        user.setName("u0");
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        SecurityRule rule = new SecurityRule();
        rule.setUser(user);
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rules.add(rule);
        long groupId = this.createGroup("group1");
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(groupId));
        rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setGroup(group);
        rules.add(rule);
        long resourceId = this.createResource("name1", "description1", "MAP", rules);
        MockSecurityContext sc = new MockSecurityContext(userService.get(u0ID));
        RESTAttribute restAttribute = new RESTAttribute();
        String NAME = "NAME";
        String VALUE = "VALUE";
        restAttribute.setName(NAME);
        restAttribute.setValue(VALUE);
        this.restResourceService.updateAttribute((SecurityContext)sc, resourceId, restAttribute);
        Resource sr = this.restResourceService.get((SecurityContext)sc, resourceId, false);
        Attribute attribute = (Attribute)sr.getAttribute().get(0);
        RESTResourceServiceImplTest.assertEquals((String)NAME, (String)attribute.getName());
        RESTResourceServiceImplTest.assertEquals((String)VALUE, (String)attribute.getValue());
        RESTResourceServiceImplTest.assertEquals((Object)DataType.STRING, (Object)attribute.getType());
        RESTResourceServiceImplTest.assertEquals((String)"u0", (String)sr.getCreator());
        RESTResourceServiceImplTest.assertEquals((String)"u0", (String)sr.getEditor());
        long u1ID = this.createUser("u1", Role.USER, "p1", groupId);
        user = new User();
        user.setId(Long.valueOf(u1ID));
        user.setName("u1");
        sc = new MockSecurityContext(userService.get(u1ID));
        restAttribute = new RESTAttribute();
        NAME = "NAME";
        VALUE = "VALUE1";
        restAttribute.setName(NAME);
        restAttribute.setValue(VALUE);
        this.restResourceService.updateAttribute((SecurityContext)sc, resourceId, restAttribute);
        sr = this.restResourceService.get((SecurityContext)sc, resourceId, false);
        attribute = (Attribute)sr.getAttribute().get(0);
        RESTResourceServiceImplTest.assertEquals((String)NAME, (String)attribute.getName());
        RESTResourceServiceImplTest.assertEquals((String)VALUE, (String)attribute.getValue());
        RESTResourceServiceImplTest.assertEquals((Object)DataType.STRING, (Object)attribute.getType());
        RESTResourceServiceImplTest.assertEquals((String)"u0", (String)sr.getCreator());
        RESTResourceServiceImplTest.assertEquals((String)"u1", (String)sr.getEditor());
    }

    @Test
    public void testUpdateResourceSecurityRules_withoutPermissions() throws Exception {
        long resourceId = this.createResource("name1", "description1", "MAP");
        long userId = this.createUser("user", Role.USER, "user");
        MockSecurityContext sc = new MockSecurityContext(userService.get(userId));
        SecurityRule securityRule = new ServiceTestBase.SecurityRuleBuilder().build();
        Assertions.assertThrows(ForbiddenErrorWebEx.class, () -> this.restResourceService.updateSecurityRules(sc, resourceId, new SecurityRuleList(List.of(securityRule))));
    }

    @Test
    public void testUpdateResourceSecurityRules_ipRangeUpdate() throws Exception {
        long adminId = this.createUser("user", Role.ADMIN, "user");
        long resourceId = this.createResource("name1", "description1", "MAP");
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminId));
        IPRange ipRange = new IPRange();
        ipRange.setCidr("192.168.1.1/24");
        ipRange.setDescription("range");
        ipRangeService.insert(ipRange);
        SecurityRuleList securityRulelist = new SecurityRuleList(List.of(new ServiceTestBase.SecurityRuleBuilder().ipRanges(Set.of(ipRange)).build()));
        this.restResourceService.updateSecurityRules((SecurityContext)sc, resourceId, securityRulelist);
        List securityRules = resourceService.getSecurityRules(resourceId);
        RESTResourceServiceImplTest.assertEquals((int)1, (int)securityRules.size());
        Set ipRanges = ((SecurityRule)securityRules.get(0)).getIpRanges();
        RESTResourceServiceImplTest.assertEquals((int)1, (int)ipRanges.size());
        IPRange savedIpRange = (IPRange)new ArrayList(ipRanges).get(0);
        RESTResourceServiceImplTest.assertEquals((String)ipRange.getCidr(), (String)savedIpRange.getCidr());
        RESTResourceServiceImplTest.assertEquals((String)ipRange.getDescription(), (String)savedIpRange.getDescription());
    }
}

