/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.password.SecurityUtils;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.keycloak.GeoStoreKeycloakAuthoritiesMapper;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakTokenDetails;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.springsecurity.account.KeycloakRole;
import org.keycloak.adapters.springsecurity.account.SimpleKeycloakAccount;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.representations.AccessToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class GeoStoreKeycloakAuthProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LogManager.getLogger(GeoStoreKeycloakAuthProvider.class);
    private final KeyCloakConfiguration configuration;
    @Autowired
    private UserService userService;
    @Autowired
    private UserGroupService groupService;

    public GeoStoreKeycloakAuthProvider(KeyCloakConfiguration configuration) {
        this.configuration = configuration;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Set<UserGroup> keycloakGroups;
        KeycloakAuthenticationToken token = (KeycloakAuthenticationToken)authentication;
        OidcKeycloakAccount account = token.getAccount();
        KeycloakSecurityContext context = account.getKeycloakSecurityContext();
        AccessToken accessToken = context.getToken();
        String accessTokenStr = context.getTokenString();
        String refreshToken = null;
        Long expiration = null;
        HttpServletRequest request = OAuth2Utils.getRequest();
        if (accessToken != null && !accessToken.isExpired()) {
            expiration = accessToken.getExp();
            if (request != null) {
                request.setAttribute("access_token", (Object)accessToken);
            }
        }
        if (context instanceof RefreshableKeycloakSecurityContext) {
            refreshToken = ((RefreshableKeycloakSecurityContext)context).getRefreshToken();
            if (request != null) {
                request.setAttribute("refresh_token", (Object)refreshToken);
            }
        }
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        GeoStoreKeycloakAuthoritiesMapper grantedAuthoritiesMapper = new GeoStoreKeycloakAuthoritiesMapper(this.configuration.getRoleMappings(), this.configuration.getGroupMappings(), this.configuration.isDropUnmapped());
        for (String role : token.getAccount().getRoles()) {
            grantedAuthorities.add((GrantedAuthority)new KeycloakRole(role));
        }
        Collection<? extends GrantedAuthority> mapped = this.mapAuthorities(grantedAuthoritiesMapper, grantedAuthorities);
        KeycloakTokenDetails details = new KeycloakTokenDetails(accessTokenStr, refreshToken, expiration);
        details.setIdToken(context.getIdTokenString());
        String username = this.getUsername(authentication);
        HashSet<UserGroup> hashSet = keycloakGroups = grantedAuthoritiesMapper != null ? grantedAuthoritiesMapper.getGroups() : new HashSet<UserGroup>();
        if (this.configuration.isAutoCreateUser()) {
            keycloakGroups = this.importGroups(keycloakGroups, grantedAuthorities);
        }
        User user = this.retrieveUser(username, "", grantedAuthoritiesMapper, keycloakGroups);
        this.addEveryOne(user.getGroups());
        if (user.getRole() == null) {
            Role defRole = this.configuration.getAuthenticatedDefaultRole();
            user.setRole(defRole);
        }
        if (user.getGroups() == null) {
            user.setGroups(new HashSet());
        }
        PreAuthenticatedAuthenticationToken result = new PreAuthenticatedAuthenticationToken((Object)user, (Object)"", mapped);
        result.setDetails((Object)details);
        return result;
    }

    private Collection<? extends GrantedAuthority> mapAuthorities(GeoStoreKeycloakAuthoritiesMapper grantedAuthoritiesMapper, Collection<? extends GrantedAuthority> authorities) {
        return grantedAuthoritiesMapper != null ? grantedAuthoritiesMapper.mapAuthorities(authorities) : authorities;
    }

    public boolean supports(Class<?> aClass) {
        return KeycloakAuthenticationToken.class.isAssignableFrom(aClass);
    }

    protected User retrieveUser(String userName, String credentials, GeoStoreKeycloakAuthoritiesMapper mapper, Set<UserGroup> groups) {
        User user;
        block11: {
            user = null;
            if (this.userService != null) {
                try {
                    user = this.userService.get(userName);
                }
                catch (NotFoundServiceEx e) {
                    if (!LOGGER.isDebugEnabled()) break block11;
                    LOGGER.warn("Keycloak user not found in DB.", (Throwable)e);
                }
            }
        }
        if (user == null) {
            user = new User();
            user.setName(userName);
            user.setNewPassword(credentials);
            user.setEnabled(true);
            Role role = this.mappedRole(mapper);
            user.setRole(role);
            if (groups == null) {
                groups = new HashSet<UserGroup>();
            }
            user.setGroups(groups);
            if (this.userService != null && this.configuration.isAutoCreateUser()) {
                try {
                    long id = this.userService.insert(user);
                    user = this.userService.get(id);
                }
                catch (BadRequestServiceEx | NotFoundServiceEx e) {
                    LOGGER.error("Exception while inserting the user.", e);
                }
            } else {
                user.setTrusted(true);
            }
        } else {
            Role role = this.mappedRole(mapper);
            if (this.isUpdateUser(user, groups, role)) {
                this.updateRoleAndGroups(role, groups, user);
            }
        }
        return user;
    }

    private User updateRoleAndGroups(Role role, Set<UserGroup> groups, User user) {
        user.setRole(role);
        try {
            for (UserGroup g : user.getGroups()) {
                if (groups.stream().anyMatch(group -> group.getGroupName().equals(g.getGroupName()))) continue;
                UserGroup newGroup = new UserGroup();
                newGroup.setGroupName(g.getGroupName());
                newGroup.setId(g.getId());
                groups.add(g);
            }
            user.setGroups(groups);
            this.userService.update(new User(user));
            user = this.userService.get(user.getName());
        }
        catch (BadRequestServiceEx | NotFoundServiceEx ex) {
            LOGGER.error("Error while updating user role...", ex);
        }
        return user;
    }

    private boolean isUpdateUser(User user, Set<UserGroup> groups, Role mappedRole) {
        HashSet<UserGroup> incoming = new HashSet<UserGroup>(groups);
        incoming.removeAll(user.getGroups());
        if (!incoming.stream().allMatch(g -> g.getGroupName().equals(GroupReservedNames.EVERYONE.groupName()))) {
            return true;
        }
        return this.configuration.isAutoCreateUser() && (user.getRole() == null || !user.getRole().equals((Object)mappedRole));
    }

    private Role mappedRole(GeoStoreKeycloakAuthoritiesMapper mapper) {
        Role role = null;
        if (mapper != null && mapper.getRole() != null) {
            role = mapper.getRole();
        }
        if (role == null) {
            role = this.configuration.getAuthenticatedDefaultRole();
        }
        if (role == null) {
            role = Role.USER;
        }
        return role;
    }

    private String getUsername(Authentication authentication) {
        SimpleKeycloakAccount account;
        AccessToken token;
        String username = null;
        if (authentication != null && authentication.getDetails() instanceof SimpleKeycloakAccount && (token = (account = (SimpleKeycloakAccount)authentication.getDetails()).getKeycloakSecurityContext().getToken()) != null) {
            username = token.getPreferredUsername();
        }
        if (username == null) {
            username = SecurityUtils.getUsername((Object)authentication);
        }
        return username;
    }

    private Set<UserGroup> importGroups(Set<UserGroup> mappedGroups, Collection<GrantedAuthority> authorities) {
        HashSet<UserGroup> returnSet = new HashSet<UserGroup>(mappedGroups.size());
        try {
            if (mappedGroups == null || mappedGroups.isEmpty()) {
                for (GrantedAuthority auth : authorities) {
                    UserGroup res = this.importGroup(auth);
                    returnSet.add(res);
                }
            } else {
                for (UserGroup g : mappedGroups) {
                    UserGroup res = this.importGroup(g.getGroupName());
                    returnSet.add(res);
                }
            }
        }
        catch (BadRequestServiceEx e) {
            LOGGER.error("Error while synchronizing groups.... Error is: ", (Throwable)e);
        }
        return returnSet;
    }

    private UserGroup importGroup(GrantedAuthority a) throws BadRequestServiceEx {
        return this.importGroup(a.getAuthority());
    }

    private UserGroup importGroup(String groupName) throws BadRequestServiceEx {
        UserGroup group;
        if (this.groupService != null) {
            group = this.groupService.get(groupName);
            if (group == null) {
                LOGGER.log(Level.INFO, "Creating new group from Keycloak: " + groupName);
                group = new UserGroup();
                group.setGroupName(groupName);
                long id = this.groupService.insert(group);
                group = this.groupService.get(id);
            }
        } else {
            group = new UserGroup();
            group.setGroupName(groupName);
        }
        return group;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setGroupService(UserGroupService groupService) {
        this.groupService = groupService;
    }

    private void addEveryOne(Set<UserGroup> groups) {
        String everyone = GroupReservedNames.EVERYONE.groupName();
        if (!groups.stream().anyMatch(g -> g.getGroupName().equals(everyone))) {
            UserGroup everyoneGroup = new UserGroup();
            everyoneGroup.setEnabled(true);
            everyoneGroup.setId(Long.valueOf(-1L));
            everyoneGroup.setGroupName(GroupReservedNames.EVERYONE.groupName());
            groups.add(everyoneGroup);
        }
    }
}

