/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.GrantedAuthoritiesMapper;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakConfiguration;
import it.geosolutions.geostore.services.rest.utils.GeoStoreContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class GeoStoreKeycloakAuthoritiesMapper
implements GrantedAuthoritiesMapper {
    private static final String ROLE_PREFIX = "ROLE_";
    private static final Logger LOGGER = LogManager.getLogger(GeoStoreKeycloakAuthoritiesMapper.class);
    private final Map<String, String> roleMappings;
    private final Map<String, String> groupMappings;
    private Set<UserGroup> groups;
    private Role role;
    private boolean dropUnmapped = false;
    private int idCounter;

    GeoStoreKeycloakAuthoritiesMapper(Map<String, String> roleMappings, Map<String, String> groupMappings, boolean dropUnmapped) {
        this.roleMappings = roleMappings;
        this.groupMappings = groupMappings;
        if (LOGGER.isDebugEnabled() && roleMappings != null) {
            LOGGER.debug("Role mappings have been configured....");
        }
        this.idCounter = 1;
        this.dropUnmapped = dropUnmapped;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
        void var4_7;
        HashSet<Object> mapped = new HashSet<Object>(authorities.size());
        for (GrantedAuthority grantedAuthority : authorities) {
            GrantedAuthority newAuthority = this.mapAuthority(grantedAuthority.getAuthority());
            if (newAuthority == null) continue;
            mapped.add(newAuthority);
        }
        KeyCloakConfiguration configuration = GeoStoreContext.bean(KeyCloakConfiguration.class);
        Object var4_5 = null;
        if (configuration != null) {
            Role def = configuration.getAuthenticatedDefaultRole();
            if (def == null) {
                def = Role.USER;
            }
            String string = ROLE_PREFIX + def.name();
        }
        void finalDefRoleStr = var4_7;
        if (var4_7 != null && !mapped.stream().anyMatch(arg_0 -> GeoStoreKeycloakAuthoritiesMapper.lambda$mapAuthorities$0((String)finalDefRoleStr, arg_0))) {
            SimpleGrantedAuthority ga2 = new SimpleGrantedAuthority((String)var4_7);
            mapped.add(ga2);
        }
        if (this.getRole() == null) {
            this.setDefaultRole();
        }
        return mapped;
    }

    void mapAuthorities(List<String> authorities) {
        if (authorities != null) {
            authorities.forEach(r -> this.mapStringAuthority((String)r));
        }
        if (this.getRole() == null) {
            this.setDefaultRole();
        }
    }

    private void setDefaultRole() {
        KeyCloakConfiguration configuration = GeoStoreContext.bean(KeyCloakConfiguration.class);
        Role role = configuration != null ? configuration.getAuthenticatedDefaultRole() : null;
        this.setRole(role);
    }

    private GrantedAuthority mapAuthority(String name) {
        String authName = this.mapStringAuthority(name);
        if (authName == null) {
            return null;
        }
        return new SimpleGrantedAuthority(authName);
    }

    private String mapStringAuthority(String name) {
        name = name.toUpperCase();
        String authName = this.roleMappings == null ? this.defaultRoleMatch(name) : this.userMappingsMatch(name);
        if (authName == null) {
            authName = name;
            if (this.groupMappings != null) {
                authName = this.groupMappings.get(authName);
            }
            if (authName == null && !this.dropUnmapped) {
                authName = name;
            }
            if (authName != null) {
                this.addGroup(authName);
            }
        }
        return authName;
    }

    private String userMappingsMatch(String name) {
        Object result;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Using the configured role mappings..");
        }
        if ((result = this.roleMappings.get(name)) != null) {
            try {
                Role role = Role.valueOf((String)result);
                if (this.getRole() == null || role.ordinal() < this.getRole().ordinal()) {
                    this.setRole(role);
                }
                result = ROLE_PREFIX + (String)result;
            }
            catch (Exception e) {
                String message = "The value " + (String)result + " set to match role " + name + " is not a valid Role. You should use one of ADMIN,USER,GUEST";
                LOGGER.error(message, (Throwable)e);
                throw new RuntimeException(message);
            }
        }
        return result;
    }

    private String defaultRoleMatch(String name) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Matching the keycloak role to geostore roles based on name equality...");
        }
        String result = null;
        if (name.equalsIgnoreCase(Role.ADMIN.name())) {
            result = ROLE_PREFIX + Role.ADMIN.name();
            this.setRole(Role.ADMIN);
        } else if (name.equalsIgnoreCase(Role.USER.name())) {
            result = ROLE_PREFIX + Role.USER.name();
            this.setRole(Role.USER);
        } else if (name.equalsIgnoreCase(Role.GUEST.name())) {
            result = ROLE_PREFIX + Role.GUEST.name();
            this.setRole(Role.GUEST);
        }
        return result;
    }

    public Set<UserGroup> getGroups() {
        if (this.groups == null) {
            return new HashSet<UserGroup>();
        }
        return this.groups;
    }

    Role getRole() {
        return this.role;
    }

    private void setRole(Role role) {
        if (this.role == null) {
            this.role = role;
        } else if (this.role.ordinal() > role.ordinal()) {
            this.role = role;
        }
    }

    private void addGroup(String groupName) {
        if (this.groups == null) {
            this.groups = new HashSet<UserGroup>();
        }
        UserGroup userGroup = new UserGroup();
        userGroup.setGroupName(groupName);
        userGroup.setId(Long.valueOf(this.idCounter));
        ++this.idCounter;
        userGroup.setEnabled(true);
        this.groups.add(userGroup);
    }

    int getIdCounter() {
        return this.idCounter;
    }
}

