/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.keycloak.GeoStoreKeycloakAuthProvider;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakHelper;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakLoginService;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakAuthenticationEntryPoint;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakCookieUtils;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakTokenDetails;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.utils.GeoStoreContext;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class KeyCloakFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LogManager.getLogger(KeyCloakFilter.class);
    private final GeoStoreKeycloakAuthProvider authenticationProvider;
    private final KeyCloakHelper helper;
    private final KeyCloakConfiguration configuration;
    private final TokenAuthenticationCache cache;
    @Autowired
    protected UserService userService;

    public KeyCloakFilter(KeyCloakHelper helper, TokenAuthenticationCache cache, KeyCloakConfiguration configuration, GeoStoreKeycloakAuthProvider authenticationProvider) {
        this.helper = helper;
        this.authenticationProvider = authenticationProvider;
        this.cache = cache;
        this.configuration = configuration;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enabledAndValid() && SecurityContextHolder.getContext().getAuthentication() == null) {
            Authentication authentication = this.authenticate((HttpServletRequest)request, (HttpServletResponse)response);
            if (authentication != null) {
                SecurityContextHolder.getContext().setAuthentication(authentication);
                if (authentication.getDetails() instanceof KeycloakTokenDetails) {
                    KeycloakTokenDetails details = (KeycloakTokenDetails)authentication.getDetails();
                    if (details.getAccessToken() != null) {
                        RequestContextHolder.getRequestAttributes().setAttribute("access_token", (Object)details.getAccessToken(), 0);
                    }
                    if (details.getRefreshToken() != null) {
                        RequestContextHolder.getRequestAttributes().setAttribute("refresh_token", (Object)details.getRefreshToken(), 0);
                    }
                }
            }
            RequestContextHolder.getRequestAttributes().setAttribute("PROVIDER", (Object)"keycloak", 0);
        }
        chain.doFilter(request, response);
    }

    private boolean enabledAndValid() {
        return this.configuration.isEnabled() && this.configuration.getJsonConfig() != null;
    }

    protected Authentication authenticateAndUpdateCache(HttpServletRequest request, HttpServletResponse response) {
        KeycloakDeployment deployment = this.helper.getDeployment(request, response);
        RequestAuthenticator authenticator = this.helper.getAuthenticator(request, response, deployment);
        AuthOutcome result = authenticator.authenticate();
        Authentication auth = null;
        if (result.equals((Object)AuthOutcome.AUTHENTICATED)) {
            auth = SecurityContextHolder.getContext().getAuthentication();
            auth = this.authenticationProvider.authenticate(auth);
            this.updateCache(auth);
        } else if (result.equals((Object)AuthOutcome.NOT_ATTEMPTED)) {
            KeycloakAuthenticationEntryPoint entryPoint = deployment.isBearerOnly() ? new KeycloakAuthenticationEntryPoint(null) : new KeycloakAuthenticationEntryPoint(authenticator.getChallenge());
            Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).setAttribute(KeyCloakLoginService.KEYCLOAK_REDIRECT, (Object)entryPoint, 0);
        } else {
            LOGGER.warn("Failed to authentication and to redirect the user.");
        }
        return auth;
    }

    protected void updateCache(Authentication authentication) {
        Object details = authentication.getDetails();
        if (details instanceof KeycloakTokenDetails) {
            KeyCloakHelper helper = GeoStoreContext.bean(KeyCloakHelper.class);
            KeycloakTokenDetails keycloakDetails = (KeycloakTokenDetails)details;
            String accessToken = keycloakDetails.getAccessToken();
            if (accessToken != null && !accessToken.isEmpty()) {
                this.cache.putCacheEntry(accessToken, authentication);
                if (helper != null) {
                    SimpleHttpFacade facade = new SimpleHttpFacade(OAuth2Utils.getRequest(), OAuth2Utils.getResponse());
                    KeycloakDeployment deployment = helper.getDeployment((HttpFacade)facade);
                    KeycloakCookieUtils.setTokenCookie(deployment, (HttpFacade)facade, keycloakDetails);
                }
            }
        }
    }

    protected Authentication authenticate(HttpServletRequest request, HttpServletResponse response) {
        Authentication authentication = null;
        String token = OAuth2Utils.tokenFromParamsOrBearer("access_token", request);
        if (token != null) {
            KeycloakTokenDetails details;
            authentication = this.cache.get(token);
            if (authentication != null && authentication.getDetails() instanceof KeycloakTokenDetails && (details = (KeycloakTokenDetails)authentication.getDetails()).getExpiration().before(new Date())) {
                LOGGER.warn("Token has expired and the refresh token endpoint has not been called. The request will not be authorized by the keycloak filter");
                this.cache.removeEntry(details.getAccessToken());
                authentication = null;
            }
            if (authentication == null) {
                authentication = this.authenticateAndUpdateCache(request, response);
            }
        } else {
            authentication = this.authenticateAndUpdateCache(request, response);
        }
        return authentication;
    }
}

