/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.bearer;

import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.OpenIdConnectConfiguration;
import it.geosolutions.geostore.services.rest.security.oauth2.openid_connect.bearer.OpenIdTokenValidator;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AudienceAccessTokenValidator
implements OpenIdTokenValidator {
    private final String AUDIENCE_CLAIM_NAME = "aud";
    private final String APPID_CLAIM_NAME = "appid";
    private final String KEYCLOAK_AUDIENCE_CLAIM_NAME = "azp";

    @Override
    public void verifyToken(OpenIdConnectConfiguration config, Map claimsJWT, Map userInfoClaims) throws Exception {
        String clientId = config.getClientId();
        if (claimsJWT.get("aud") != null) {
            if (claimsJWT.get("aud").equals(clientId)) {
                return;
            }
            if (claimsJWT.get("aud") instanceof Collection && ((Collection)claimsJWT.get("aud")).contains(clientId)) {
                return;
            }
        }
        if (claimsJWT.get("appid") != null && claimsJWT.get("appid").equals(clientId)) {
            return;
        }
        Object azp = claimsJWT.get("azp");
        if (azp != null) {
            if (azp instanceof String) {
                if (azp.equals(config.getClientId())) {
                    return;
                }
            } else if (azp instanceof List) {
                List azps = (List)azp;
                for (Object o : azps) {
                    if (!(o instanceof String) || !o.equals(clientId)) continue;
                    return;
                }
            }
        }
        throw new Exception("JWT Bearer token - probably not meant for this application");
    }
}

