/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreOAuthRestTemplate;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreRemoteTokenServices;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.google.OAuthGoogleSecurityConfiguration;
import it.geosolutions.geostore.services.rest.security.oauth2.google.OpenIdFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OpenIdIntegrationTest {
    private static final String CLIENT_ID = "kbyuFDidLLm280LIwVFiazOqjO3ty8KH";
    private static final String CLIENT_SECRET = "60Op4HFM0I8ajz0WdiStAbziZ-VFQttXuxixHHs2R7r7-CW8GR79l-mmLqMhc-Sa";
    private static final String CODE = "R-2CqM7H1agwc7Cx";
    private static final String CODE_GROUPS_HD = "CODE_GROUPS_HD";
    private static final String CODE_ROLES_ADMIN = "CODE_ROLES_ADMIN";
    private static final String CODE_ROLES_EMPTY = "CODE_ROLES_EMPTY";
    private static final String CODE_GROUPS_RECON = "CODE_GROUPS_RECON";
    private static final String CODE_ROLES_GUEST = "CODE_ROLES_GUEST";
    private static WireMockServer openIdService;
    private String authService;
    private OpenIdFilter filter;
    private TestOAuth2Configuration configuration;

    @BeforeClass
    public static void beforeClass() {
        openIdService = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().notifier((Notifier)new ConsoleNotifier(true)));
        openIdService.start();
        openIdService.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/certs")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("{\"keys\":[]}")));
        openIdService.stubFor(WireMock.any((UrlPattern)WireMock.urlPathEqualTo((String)"/userinfo")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("{}")));
    }

    @Before
    public void before() {
        this.authService = "http://localhost:" + openIdService.port();
        this.configuration = new TestOAuth2Configuration();
        this.configuration.setClientId(CLIENT_ID);
        this.configuration.setClientSecret(CLIENT_SECRET);
        this.configuration.setRevokeEndpoint(this.authService + "/revoke");
        this.configuration.setAccessTokenUri(this.authService + "/token");
        this.configuration.setAuthorizationUri(this.authService + "/authorize");
        this.configuration.setCheckTokenEndpointUrl(this.authService + "/userinfo");
        this.configuration.setEnabled(true);
        this.configuration.setAutoCreateUser(true);
        this.configuration.setIdTokenUri(this.authService + "/certs");
        this.configuration.setBeanName("googleOAuth2Config");
        this.configuration.setEnableRedirectEntryPoint(true);
        this.configuration.setRedirectUri("../../../geostore/rest/users/user/details");
        this.configuration.setScopes("openId,email");
        OAuthGoogleSecurityConfiguration securityConfiguration = new OAuthGoogleSecurityConfiguration(){

            protected GeoStoreOAuthRestTemplate restTemplate() {
                return new GeoStoreOAuthRestTemplate(this.resourceDetails(), (OAuth2ClientContext)new DefaultOAuth2ClientContext((AccessTokenRequest)new DefaultAccessTokenRequest()), this.configuration());
            }

            public OAuth2Configuration configuration() {
                return OpenIdIntegrationTest.this.configuration;
            }
        };
        GeoStoreOAuthRestTemplate restTemplate = securityConfiguration.oauth2RestTemplate();
        this.filter = new OpenIdFilter((GeoStoreRemoteTokenServices)securityConfiguration.googleTokenServices(), restTemplate, (OAuth2Configuration)this.configuration, securityConfiguration.oAuth2Cache());
        this.filter.setUserGroupService((UserGroupService)new DummyUserGroupService());
        this.stubTokenForCode(CODE, OpenIdIntegrationTest.jsonPayload().put("email", "ritter@erdukunde.de").build());
        this.stubTokenForCode(CODE_GROUPS_HD, OpenIdIntegrationTest.jsonPayload().put("email", "u@ex.com").put("hd", "geosolutionsgroup.com").build());
        this.stubTokenForCode(CODE_ROLES_ADMIN, OpenIdIntegrationTest.jsonPayload().put("email", "admin@ex.com").put("roles", OpenIdIntegrationTest.arr("ADMIN")).build());
        this.stubTokenForCode(CODE_ROLES_EMPTY, OpenIdIntegrationTest.jsonPayload().put("email", "demote@ex.com").put("roles", "[]").raw());
        this.stubTokenForCode(CODE_GROUPS_RECON, OpenIdIntegrationTest.jsonPayload().put("email", "recon@ex.com").put("groups", OpenIdIntegrationTest.arr("A", "B")).build());
        this.stubTokenForCode(CODE_ROLES_GUEST, OpenIdIntegrationTest.jsonPayload().put("email", "guest@ex.com").put("roles", OpenIdIntegrationTest.arr("GUEST")).build());
    }

    @After
    public void afterTest() {
        SecurityContextHolder.clearContext();
        RequestContextHolder.resetRequestAttributes();
    }

    @Test
    public void testRedirect() throws IOException, ServletException {
        MockHttpServletRequest request = this.createRequest("google/login");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)302L, (long)response.getStatus());
        Assert.assertEquals((Object)this.configuration.buildLoginUri(), (Object)response.getRedirectedUrl());
    }

    @Test
    public void testAuthentication_basic() throws IOException, ServletException {
        MockHttpServletRequest request = this.createRequest("google/login");
        request.setParameter("authorization_code", CODE);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.filter.restTemplate.getOAuth2ClientContext().getAccessTokenRequest().setAuthorizationCode(CODE);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = (User)authentication.getPrincipal();
        Assert.assertEquals((Object)"ritter@erdukunde.de", (Object)user.getName());
        Assert.assertEquals((Object)Role.USER, (Object)user.getRole());
    }

    @Test
    public void testGroupsFromToken_hdDomain() throws Exception {
        this.configuration.setGroupsClaim("hd");
        MockHttpServletRequest request = this.createRequest("google/login");
        request.setParameter("authorization_code", CODE_GROUPS_HD);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.filter.restTemplate.getOAuth2ClientContext().getAccessTokenRequest().setAuthorizationCode(CODE_GROUPS_HD);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = (User)authentication.getPrincipal();
        UserGroup group = (UserGroup)user.getGroups().stream().findAny().orElseThrow();
        Assert.assertEquals((Object)"geosolutionsgroup.com", (Object)group.getGroupName());
    }

    @Test
    public void testRoleFromToken_adminPromotion() throws Exception {
        this.configuration.setRolesClaim("roles");
        MockHttpServletRequest request = this.createRequest("google/login");
        request.setParameter("authorization_code", CODE_ROLES_ADMIN);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.filter.restTemplate.getOAuth2ClientContext().getAccessTokenRequest().setAuthorizationCode(CODE_ROLES_ADMIN);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = (User)authentication.getPrincipal();
        Assert.assertEquals((Object)Role.ADMIN, (Object)user.getRole());
    }

    @Test
    public void testRoleFromToken_emptyListDemotesToDefault() throws Exception {
        this.configuration.setRolesClaim("roles");
        MockHttpServletRequest request = this.createRequest("google/login");
        request.setParameter("authorization_code", CODE_ROLES_EMPTY);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.filter.restTemplate.getOAuth2ClientContext().getAccessTokenRequest().setAuthorizationCode(CODE_ROLES_EMPTY);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = (User)authentication.getPrincipal();
        Assert.assertEquals((Object)Role.USER, (Object)user.getRole());
    }

    @Test
    public void testProviderScopedGroupReconciliation() throws Exception {
        this.configuration.setGroupsClaim("groups");
        DummyUserGroupService svc = (DummyUserGroupService)this.filter.getUserGroupService();
        User seeded = new User();
        seeded.setId(Long.valueOf(777L));
        seeded.setName("recon@ex.com");
        seeded.setRole(Role.USER);
        seeded.setEnabled(true);
        seeded.setGroups(new HashSet());
        UserGroup local = new UserGroup();
        local.setGroupName("LOCAL_GROUP");
        local.setAttributes(new ArrayList());
        svc.insert(local);
        UserGroup otherProv = new UserGroup();
        otherProv.setGroupName("OTHER_GROUP");
        otherProv.setAttributes(new ArrayList<UserGroupAttribute>(List.of(OpenIdIntegrationTest.attr("sourceService", "other"))));
        svc.insert(otherProv);
        UserGroup oldRemote = new UserGroup();
        oldRemote.setGroupName("OLD_REMOTE");
        oldRemote.setAttributes(new ArrayList<UserGroupAttribute>(List.of(OpenIdIntegrationTest.attr("sourceService", this.configuration.getProvider()))));
        svc.insert(oldRemote);
        seeded.getGroups().add(local);
        seeded.getGroups().add(otherProv);
        seeded.getGroups().add(oldRemote);
        OpenIdFilter seededFilter = this.getOpenIdFilter(seeded, svc);
        MockHttpServletRequest request = this.createRequest("google/login");
        request.setParameter("authorization_code", CODE_GROUPS_RECON);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        seededFilter.restTemplate.getOAuth2ClientContext().getAccessTokenRequest().setAuthorizationCode(CODE_GROUPS_RECON);
        seededFilter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Set names = seeded.getGroups().stream().map(UserGroup::getGroupName).collect(Collectors.toSet());
        Assert.assertTrue((boolean)names.contains("LOCAL_GROUP"));
        Assert.assertTrue((boolean)names.contains("OTHER_GROUP"));
        Assert.assertTrue((boolean)names.contains("A"));
        Assert.assertTrue((boolean)names.contains("B"));
        Assert.assertFalse((boolean)names.contains("OLD_REMOTE"));
        for (String g : List.of("A", "B")) {
            UserGroup ug = svc.get(g);
            Assert.assertNotNull((Object)ug);
            String src = ug.getAttributes().stream().filter(a -> "sourceService".equals(a.getName())).findFirst().orElseThrow().getValue();
            Assert.assertEquals((Object)this.configuration.getProvider(), (Object)src);
        }
    }

    @Test
    public void testNewUserCreatedWithRoleFromOidc() throws Exception {
        this.configuration.setRolesClaim("roles");
        MockHttpServletRequest request = this.createRequest("google/login");
        request.setParameter("authorization_code", CODE_ROLES_ADMIN);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.filter.restTemplate.getOAuth2ClientContext().getAccessTokenRequest().setAuthorizationCode(CODE_ROLES_ADMIN);
        this.filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = (User)authentication.getPrincipal();
        Assert.assertEquals((Object)"admin@ex.com", (Object)user.getName());
        Assert.assertEquals((Object)Role.ADMIN, (Object)user.getRole());
        Assert.assertTrue((user.getAttribute() != null && user.getAttribute().stream().anyMatch(a -> "CONFIGURATION_NAME".equals(a.getName()) && this.configuration.getBeanName().equals(a.getValue())) ? 1 : 0) != 0);
    }

    @Test
    public void testExistingUserRoleOverriddenByOidc() throws Exception {
        this.configuration.setRolesClaim("roles");
        User existing = new User();
        existing.setId(Long.valueOf(901L));
        existing.setName("guest@ex.com");
        existing.setRole(Role.ADMIN);
        existing.setEnabled(true);
        existing.setGroups(new HashSet());
        existing.setAttribute(new ArrayList());
        OpenIdFilter seededFilter = this.getOpenIdFilter(existing, (DummyUserGroupService)this.filter.getUserGroupService());
        MockHttpServletRequest request = this.createRequest("google/login");
        request.setParameter("authorization_code", CODE_ROLES_GUEST);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        seededFilter.restTemplate.getOAuth2ClientContext().getAccessTokenRequest().setAuthorizationCode(CODE_ROLES_GUEST);
        seededFilter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        User user = (User)authentication.getPrincipal();
        Assert.assertEquals((Object)"guest@ex.com", (Object)user.getName());
        Assert.assertEquals((Object)Role.GUEST, (Object)user.getRole());
    }

    @Test
    public void testProviderRemoteGroupsResetAlignedAndIdempotent() throws Exception {
        this.configuration.setGroupsClaim("groups");
        DummyUserGroupService svc = (DummyUserGroupService)this.filter.getUserGroupService();
        User seeded = new User();
        seeded.setId(Long.valueOf(1001L));
        seeded.setName("recon@ex.com");
        seeded.setRole(Role.USER);
        seeded.setEnabled(true);
        seeded.setGroups(new HashSet());
        UserGroup local = new UserGroup();
        local.setGroupName("LOCAL_GROUP");
        local.setAttributes(new ArrayList());
        svc.insert(local);
        UserGroup otherProv = new UserGroup();
        otherProv.setGroupName("OTHER_GROUP");
        otherProv.setAttributes(new ArrayList<UserGroupAttribute>(List.of(OpenIdIntegrationTest.attr("sourceService", "other"))));
        svc.insert(otherProv);
        UserGroup oldRemote = new UserGroup();
        oldRemote.setGroupName("OLD_REMOTE");
        oldRemote.setAttributes(new ArrayList<UserGroupAttribute>(List.of(OpenIdIntegrationTest.attr("sourceService", this.configuration.getProvider()))));
        svc.insert(oldRemote);
        seeded.getGroups().add(local);
        seeded.getGroups().add(otherProv);
        seeded.getGroups().add(oldRemote);
        OpenIdFilter seededFilter = this.getOpenIdFilter(seeded, svc);
        MockHttpServletRequest request = this.createRequest("google/login");
        request.setParameter("authorization_code", CODE_GROUPS_RECON);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        seededFilter.restTemplate.getOAuth2ClientContext().getAccessTokenRequest().setAuthorizationCode(CODE_GROUPS_RECON);
        seededFilter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Set names = seeded.getGroups().stream().map(UserGroup::getGroupName).collect(Collectors.toSet());
        Assert.assertTrue((boolean)names.contains("LOCAL_GROUP"));
        Assert.assertTrue((boolean)names.contains("OTHER_GROUP"));
        Assert.assertFalse((boolean)names.contains("OLD_REMOTE"));
        Assert.assertTrue((boolean)names.contains("A"));
        Assert.assertTrue((boolean)names.contains("B"));
        Set providerRemotes = seeded.getGroups().stream().filter(g -> g.getAttributes() != null).filter(g -> g.getAttributes().stream().anyMatch(a -> "sourceService".equals(a.getName()) && this.configuration.getProvider().equals(a.getValue()))).map(UserGroup::getGroupName).collect(Collectors.toSet());
        Assert.assertEquals(Set.of("A", "B"), providerRemotes);
        int beforeCount = seeded.getGroups().size();
        MockHttpServletRequest request2 = this.createRequest("google/login");
        request2.setParameter("authorization_code", CODE_GROUPS_RECON);
        MockHttpServletResponse response2 = new MockHttpServletResponse();
        seededFilter.restTemplate.getOAuth2ClientContext().getAccessTokenRequest().setAuthorizationCode(CODE_GROUPS_RECON);
        seededFilter.doFilter((ServletRequest)request2, (ServletResponse)response2, (FilterChain)new MockFilterChain());
        Assert.assertEquals((long)200L, (long)response2.getStatus());
        int afterCount = seeded.getGroups().size();
        Assert.assertEquals((long)beforeCount, (long)afterCount);
        Set providerRemotesAfter = seeded.getGroups().stream().filter(g -> g.getAttributes() != null).filter(g -> g.getAttributes().stream().anyMatch(a -> "sourceService".equals(a.getName()) && this.configuration.getProvider().equals(a.getValue()))).map(UserGroup::getGroupName).collect(Collectors.toSet());
        Assert.assertEquals(Set.of("A", "B"), providerRemotesAfter);
    }

    private OpenIdFilter getOpenIdFilter(final User seeded, DummyUserGroupService svc) {
        OpenIdFilter seededFilter = new OpenIdFilter((GeoStoreRemoteTokenServices)new OAuthGoogleSecurityConfiguration(){

            protected GeoStoreOAuthRestTemplate restTemplate() {
                return (GeoStoreOAuthRestTemplate)OpenIdIntegrationTest.this.filter.restTemplate;
            }

            public OAuth2Configuration configuration() {
                return OpenIdIntegrationTest.this.configuration;
            }
        }.googleTokenServices(), (GeoStoreOAuthRestTemplate)this.filter.restTemplate, this.configuration, null){

            protected User retrieveUserWithAuthorities(String username, HttpServletRequest request, HttpServletResponse response) {
                return seeded;
            }
        };
        seededFilter.setUserGroupService((UserGroupService)svc);
        return seededFilter;
    }

    private static UserGroupAttribute attr(String n, String v) {
        UserGroupAttribute a = new UserGroupAttribute();
        a.setName(n);
        a.setValue(v);
        return a;
    }

    private void stubTokenForCode(String code, String idTokenPayloadJson) {
        String idToken = OpenIdIntegrationTest.unsignedJwtJson(idTokenPayloadJson);
        String body = "{\"access_token\":\"at-" + code + "\",\"token_type\":\"Bearer\",\"expires_in\":3600,\"id_token\":\"" + idToken + "\"}";
        openIdService.stubFor(WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withRequestBody(WireMock.containing((String)"grant_type=authorization_code")).withRequestBody(WireMock.containing((String)"client_id=kbyuFDidLLm280LIwVFiazOqjO3ty8KH")).withRequestBody(WireMock.containing((String)("code=" + code))).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody(body)));
    }

    private static String unsignedJwtJson(String payloadJson) {
        String header = "{\"alg\":\"none\"}";
        return OpenIdIntegrationTest.b64Url(header) + "." + OpenIdIntegrationTest.b64Url(payloadJson) + ".";
    }

    private static String b64Url(String s) {
        return new String(Base64.encodeBase64URLSafe((byte[])s.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    private static JsonBuilder jsonPayload() {
        return new JsonBuilder();
    }

    private static String arr(String ... items) {
        return Arrays.stream(items).map(x -> "\"" + x + "\"").collect(Collectors.joining(",", "[", "]"));
    }

    private MockHttpServletRequest createRequest(String path) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        request.setServerName("localhost");
        request.setServerPort(8080);
        request.setContextPath("/geostore");
        request.setRequestURI("/geostore/" + path);
        request.setRemoteAddr("127.0.0.1");
        request.setServletPath("/geostore");
        request.setPathInfo(path);
        request.addHeader("Host", (Object)"localhost:8080");
        ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        return request;
    }

    private static class JsonBuilder {
        private final StringBuilder sb = new StringBuilder("{");
        private boolean first = true;

        private JsonBuilder() {
        }

        JsonBuilder put(String k, String v) {
            return this.rawPair(k, "\"" + v + "\"");
        }

        JsonBuilder put(String k, int v) {
            return this.rawPair(k, String.valueOf(v));
        }

        JsonBuilder putRaw(String k, String rawJson) {
            return this.rawPair(k, rawJson);
        }

        JsonBuilder putArray(String k, String arrayJson) {
            return this.rawPair(k, arrayJson);
        }

        JsonBuilder rawPair(String k, String raw) {
            if (!this.first) {
                this.sb.append(',');
            }
            this.sb.append("\"" + k + "\":").append(raw);
            this.first = false;
            return this;
        }

        String build() {
            return this.sb.append('}').toString();
        }

        String raw() {
            return this.build();
        }
    }

    private static class DummyUserGroupService
    implements UserGroupService {
        private final Map<String, UserGroup> byName = new HashMap<String, UserGroup>();
        private final Map<Long, UserGroup> byId = new HashMap<Long, UserGroup>();
        private long nextId = 1L;

        private DummyUserGroupService() {
        }

        public long insert(UserGroup g) {
            if (g.getId() == null) {
                g.setId(Long.valueOf(this.nextId++));
            }
            if (g.getAttributes() == null) {
                g.setAttributes(new ArrayList());
            }
            this.byId.put(g.getId(), g);
            this.byName.put(g.getGroupName(), g);
            return g.getId();
        }

        public void assignUserGroup(long userId, long groupId) {
        }

        public void deassignUserGroup(long userId, long groupId) {
        }

        public UserGroup get(String name) {
            return this.byName.get(name);
        }

        public UserGroup get(long id) {
            return this.byId.get(id);
        }

        public void updateAttributes(long id, List<UserGroupAttribute> attributes) throws NotFoundServiceEx {
            UserGroup g = this.byId.get(id);
            if (g == null) {
                throw new NotFoundServiceEx("not found");
            }
            g.setAttributes(new ArrayList<UserGroupAttribute>(attributes));
            this.byName.put(g.getGroupName(), g);
        }

        public long update(UserGroup group) {
            if (group.getId() == null) {
                group.setId(Long.valueOf(this.nextId++));
            }
            if (group.getAttributes() == null) {
                group.setAttributes(new ArrayList());
            }
            this.byId.put(group.getId(), group);
            this.byName.put(group.getGroupName(), group);
            return group.getId();
        }

        public long getCount(String nameLike, boolean all) {
            return this.byName.size();
        }

        public long getCount(User authUser, String nameLike, boolean all) {
            return this.byName.size();
        }

        public boolean delete(long id) {
            return this.byId.remove(id) != null;
        }

        public Collection<UserGroup> findByAttribute(String name, List<String> values, boolean ignoreCase) {
            String n = ignoreCase ? name.toLowerCase(Locale.ROOT) : name;
            HashSet<String> vals = new HashSet<String>();
            for (String v : values) {
                vals.add(ignoreCase ? v.toLowerCase(Locale.ROOT) : v);
            }
            ArrayList<UserGroup> out = new ArrayList<UserGroup>();
            block1: for (UserGroup g : this.byName.values()) {
                List attrs = g.getAttributes();
                if (attrs == null) continue;
                for (UserGroupAttribute a : attrs) {
                    String av;
                    String an;
                    if (a.getName() == null || !(an = ignoreCase ? a.getName().toLowerCase(Locale.ROOT) : a.getName()).equals(n) || !vals.contains(av = a.getValue() == null ? "" : (ignoreCase ? a.getValue().toLowerCase(Locale.ROOT) : a.getValue()))) continue;
                    out.add(g);
                    continue block1;
                }
            }
            return out;
        }

        public UserGroup getWithAttributes(long id) throws NotFoundServiceEx, BadRequestServiceEx {
            UserGroup g = this.byId.get(id);
            if (g == null) {
                throw new NotFoundServiceEx("UserGroup not found " + id);
            }
            return g;
        }

        public void upsertAttribute(long groupId, String name, String value) throws NotFoundServiceEx, BadRequestServiceEx {
            UserGroup g = this.byId.get(groupId);
            if (g == null) {
                throw new NotFoundServiceEx("UserGroup not found " + groupId);
            }
            if (g.getAttributes() == null) {
                g.setAttributes(new ArrayList());
            }
            for (UserGroupAttribute a : g.getAttributes()) {
                if (a.getName() == null || !a.getName().equalsIgnoreCase(name)) continue;
                a.setValue(value);
                return;
            }
            UserGroupAttribute a = new UserGroupAttribute();
            a.setName(name);
            a.setValue(value);
            g.getAttributes().add(a);
        }

        public List<UserGroup> getAllAllowed(User user, Integer page, Integer entries, String nameLike, boolean all) {
            return new ArrayList<UserGroup>(this.byName.values());
        }

        public List<UserGroup> getAll(Integer page, Integer entries) {
            return new ArrayList<UserGroup>(this.byName.values());
        }

        public List<UserGroup> getAll(Integer page, Integer entries, String nameLike, boolean all) {
            return new ArrayList<UserGroup>(this.byName.values());
        }

        public List<ShortResource> updateSecurityRules(Long groupId, List<Long> resourcesToSet, boolean canRead, boolean canWrite) {
            return List.of();
        }

        public boolean insertSpecialUsersGroups() {
            return false;
        }

        public boolean removeSpecialUsersGroups() {
            return false;
        }
    }

    private static class TestOAuth2Configuration
    extends OAuth2Configuration {
        private TestOAuth2Configuration() {
        }

        public String getProvider() {
            return this.getBeanName();
        }
    }
}

