/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.utils;

import it.geosolutions.geostore.services.rest.utils.FixedCacheControlOutInterceptor;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.junit.Assert;
import org.junit.Test;

public class FixedCacheControlOutInterceptorTest {
    @Test
    public void testCacheControlHeader() {
        MessageImpl message = new MessageImpl();
        ByteArrayOutputStream sw = new ByteArrayOutputStream();
        message.setContent(OutputStream.class, (Object)sw);
        FixedCacheControlOutInterceptor interceptor = new FixedCacheControlOutInterceptor();
        interceptor.handleMessage((Message)message);
        MetadataMap headers = (MetadataMap)message.get((Object)Message.PROTOCOL_HEADERS);
        Assert.assertEquals(headers.get((Object)"Expires").get(0), (Object)"-1");
        Assert.assertEquals(headers.get((Object)"Cache-Control").get(0), (Object)"no-cache");
    }

    @Test
    public void testCacheControlPreserveExisting() {
        MessageImpl message = new MessageImpl();
        ByteArrayOutputStream sw = new ByteArrayOutputStream();
        message.setContent(OutputStream.class, (Object)sw);
        MetadataMap headers = (MetadataMap)message.get((Object)Message.PROTOCOL_HEADERS);
        if (headers == null) {
            headers = new MetadataMap();
        }
        headers.add((Object)"Test", (Object)"Test");
        message.put((Object)Message.PROTOCOL_HEADERS, (Object)headers);
        FixedCacheControlOutInterceptor interceptor = new FixedCacheControlOutInterceptor();
        interceptor.handleMessage((Message)message);
        headers = (MetadataMap)message.get((Object)Message.PROTOCOL_HEADERS);
        headers.get((Object)"Cache-Control").get(0);
        Assert.assertEquals(headers.get((Object)"Cache-Control").get(0), (Object)"no-cache");
        Assert.assertEquals(headers.get((Object)"Expires").get(0), (Object)"-1");
        Assert.assertEquals(headers.get((Object)"Test").get(0), (Object)"Test");
    }
}

