/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.security.GrantedAuthoritiesMapper;
import it.geosolutions.geostore.services.rest.security.GroupsRolesService;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.AbstractContextMapper;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.util.Assert;

public class GeoStoreLdapAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator
implements GroupsRolesService {
    private static final Log logger = LogFactory.getLog(GeoStoreLdapAuthoritiesPopulator.class);
    private final SpringSecurityLdapTemplate ldapTemplate;
    private final SearchControls searchControls = new SearchControls();
    private final String groupSearchBase;
    private final String roleSearchBase;
    private final String allGroupsSearchFilter = "(objectClass=group)";
    private final String allRolesSearchFilter = "(objectClass=group)";
    private String groupRoleAttribute = "cn";
    private String groupSearchFilter = "(member={0})";
    private String roleSearchFilter = "(member={0})";
    private String rolePrefix = "ROLE_";
    private boolean searchSubtree = false;
    private boolean enableHierarchicalGroups = false;
    private String groupInGroupSearchFilter = "(member={0})";
    private int maxLevelGroupsSearch = Integer.MAX_VALUE;
    private boolean convertToUpperCase = true;
    private GrantedAuthoritiesMapper roleMapper = null;
    private GrantedAuthoritiesMapper groupMapper = null;

    public GeoStoreLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase, String roleSearchBase) {
        super(contextSource, groupSearchBase);
        Assert.notNull((Object)contextSource, (String)"contextSource must not be null");
        this.ldapTemplate = new SpringSecurityLdapTemplate(contextSource);
        this.ldapTemplate.setSearchControls(this.searchControls);
        this.groupSearchBase = groupSearchBase;
        if (groupSearchBase == null) {
            logger.info((Object)"groupSearchBase is null. No group search will be performed.");
        } else if (groupSearchBase.length() == 0) {
            logger.info((Object)"groupSearchBase is empty. Searches will be performed from the context source base");
        }
        this.roleSearchBase = roleSearchBase;
        if (roleSearchBase == null) {
            logger.info((Object)"roleSearchBase is null. No group search will be performed.");
        } else if (roleSearchBase.length() == 0) {
            logger.info((Object)"roleSearchBase is empty. Searches will be performed from the context source base");
        }
    }

    @Deprecated
    public void setAuthoritiesMapper(GrantedAuthoritiesMapper authoritiesMapper) {
        logger.error((Object)"AuthoritiesMapper is deprecated, please set roleMapper and groupMapper separately");
        this.roleMapper = authoritiesMapper;
        this.groupMapper = authoritiesMapper;
    }

    public void setRoleMapper(GrantedAuthoritiesMapper roleMapper) {
        this.roleMapper = roleMapper;
    }

    public void setGroupMapper(GrantedAuthoritiesMapper groupMapper) {
        this.groupMapper = groupMapper;
    }

    public Set<GrantedAuthority> getGroupMembershipRoles(String userDn, String username) {
        HashSet<GrantedAuthority> ret = new HashSet<GrantedAuthority>();
        ret.addAll(this.getGroups(userDn, username));
        ret.addAll(this.getRoles(userDn, username));
        return ret;
    }

    private Set<GrantedAuthority> getRoles(String userDn, String username) {
        String[] stringArray;
        if (this.roleSearchBase == null) {
            return new HashSet<GrantedAuthority>();
        }
        HashSet<Object> authorities = new HashSet<GrantedAuthority>();
        if (username == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = userDn;
            stringArray = stringArray2;
            stringArray2[1] = username;
        }
        String[] searchParams = stringArray;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for roles for user '" + username + "', DN = '" + userDn + "', with filter " + this.roleSearchFilter + " in search base '" + this.roleSearchBase + "'"));
        }
        String[] rolesRoots = this.roleSearchBase.split(";");
        String filter = username == null ? "(objectClass=group)" : this.roleSearchFilter;
        for (String rolesRoot : rolesRoots) {
            this.addAuthorities(searchParams, authorities, rolesRoot, filter, this.rolePrefix, false);
        }
        if (this.roleMapper != null) {
            authorities = new HashSet(this.roleMapper.mapAuthorities(authorities));
        }
        return authorities;
    }

    private Set<GrantedAuthority> getGroups(String userDn, String username) {
        String[] stringArray;
        if (this.groupSearchBase == null) {
            return new HashSet<GrantedAuthority>();
        }
        HashSet<Object> authorities = new HashSet<GrantedAuthority>();
        if (username == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = userDn;
            stringArray = stringArray2;
            stringArray2[1] = username;
        }
        String[] searchParams = stringArray;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for groups for user '" + username + "', DN = '" + userDn + "', with filter " + this.groupSearchFilter + " in search base '" + this.groupSearchBase + "'"));
        }
        String[] groupsRoots = this.groupSearchBase.split(";");
        String filter = username == null ? "(objectClass=group)" : this.groupSearchFilter;
        for (String groupsRoot : groupsRoots) {
            this.addAuthorities(searchParams, authorities, groupsRoot, filter, null, this.enableHierarchicalGroups);
        }
        if (this.groupMapper != null) {
            authorities = new HashSet(this.groupMapper.mapAuthorities(authorities));
        }
        return authorities;
    }

    @Override
    public Set<GrantedAuthority> getAllGroups() {
        return this.getGroups(null, null);
    }

    @Override
    public Set<GrantedAuthority> getAllRoles() {
        return this.getRoles(null, null);
    }

    private void addAuthorities(String[] params, Set<GrantedAuthority> authorities, String root, String filter, String authorityPrefix, boolean hierarchical) {
        this.addAuthorities(params, authorities, root, filter, authorityPrefix, hierarchical, 0);
    }

    private void addAuthorities(String[] params, Set<GrantedAuthority> authorities, String root, String filter, String authorityPrefix, boolean hierarchical, int level) {
        String formattedFilter = MessageFormat.format(filter, params);
        List ldapAuthorities = this.ldapTemplate.search(root, formattedFilter, (ContextMapper)new AbstractContextMapper(){

            protected Object doMapFromContext(DirContextOperations ctx) {
                return new Authority(ctx.getStringAttribute(GeoStoreLdapAuthoritiesPopulator.this.groupRoleAttribute), ctx.getNameInNamespace());
            }
        });
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found " + ldapAuthorities.size() + " authorities from search"));
        }
        for (Object authority : ldapAuthorities) {
            Authority ldapAuthority = (Authority)authority;
            boolean added = this.addAuthority(authorities, authorityPrefix, ldapAuthority.getName());
            if (!added || !hierarchical || level >= this.maxLevelGroupsSearch) continue;
            String[] searchParams = new String[]{ldapAuthority.getDn(), ldapAuthority.getName()};
            this.addAuthorities(searchParams, authorities, root, this.groupInGroupSearchFilter, authorityPrefix, hierarchical, level + 1);
        }
    }

    private boolean addAuthority(Set<GrantedAuthority> authorities, String authorityPrefix, String authority) {
        String prefix;
        String rolename;
        SimpleGrantedAuthority role;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding authority: " + authorityPrefix + "::" + authority));
        }
        if (this.convertToUpperCase) {
            authority = authority.toUpperCase();
        }
        if (!authorities.contains(role = new SimpleGrantedAuthority(rolename = (prefix = authorityPrefix != null && !authority.startsWith(authorityPrefix) ? authorityPrefix : "") + authority))) {
            authorities.add((GrantedAuthority)role);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authority added:  " + rolename));
            }
            return true;
        }
        logger.debug((Object)("Authority not added: " + rolename));
        return false;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        super.setConvertToUpperCase(convertToUpperCase);
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        super.setGroupRoleAttribute(groupRoleAttribute);
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        super.setGroupSearchFilter(groupSearchFilter);
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setRoleSearchFilter(String roleSearchFilter) {
        this.roleSearchFilter = roleSearchFilter;
    }

    public void setRolePrefix(String rolePrefix) {
        super.setRolePrefix(rolePrefix);
        this.rolePrefix = rolePrefix;
    }

    public void setSearchSubtree(boolean searchSubtree) {
        if (searchSubtree) {
            this.searchControls.setSearchScope(2);
        } else {
            this.searchControls.setSearchScope(1);
        }
        this.searchSubtree = searchSubtree;
    }

    public void setEnableHierarchicalGroups(boolean enableHierarchicalGroups) {
        this.enableHierarchicalGroups = enableHierarchicalGroups;
    }

    public void setGroupInGroupSearchFilter(String groupInGroupSearchFilter) {
        this.groupInGroupSearchFilter = groupInGroupSearchFilter;
    }

    public void setMaxLevelGroupsSearch(int maxLevelGroupsSearch) {
        this.maxLevelGroupsSearch = maxLevelGroupsSearch;
    }

    private static class Authority {
        private final String name;
        private final String dn;

        public Authority(String name, String dn) {
            this.name = name;
            this.dn = dn;
        }

        public String getName() {
            return this.name;
        }

        public String getDn() {
            return this.dn;
        }
    }
}

