/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;

public class RestAuthenticationEntryPoint
extends BasicAuthenticationEntryPoint {
    private static final String LOGIN_PATH = "users/user/details";
    private static final String SESSION_LOGIN_PATH = "session/";
    private static final Logger LOGGER = LogManager.getLogger(RestAuthenticationEntryPoint.class);

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        URI url = null;
        try {
            url = new URI(request.getRequestURI());
        }
        catch (URISyntaxException e) {
            LOGGER.error("Invalid URI:" + request.getRequestURI());
            super.commence(request, response, authException);
            return;
        }
        if (url == null) {
            super.commence(request, response, authException);
            return;
        }
        if (url.getPath().contains(LOGIN_PATH) || url.getPath().contains(SESSION_LOGIN_PATH)) {
            response.setHeader("WWW-Authenticate", "FormBased");
            response.setStatus(401);
        } else {
            super.commence(request, response, authException);
        }
    }
}

