/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakTokenDetails;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.common.util.KeycloakUriBuilder;

class KeycloakCookieUtils {
    private static final String SEPARATOR = "___";

    KeycloakCookieUtils() {
    }

    static void setTokenCookie(KeycloakDeployment deployment, HttpFacade facade, KeycloakTokenDetails tokenDetails) {
        String accessToken = tokenDetails.getAccessToken();
        String idToken = tokenDetails.getIdToken();
        String refreshToken = tokenDetails.getRefreshToken();
        String cookie = accessToken + SEPARATOR + idToken + SEPARATOR + refreshToken;
        String cookiePath = KeycloakCookieUtils.getCookiePath(deployment, facade);
        facade.getResponse().setCookie("KEYCLOAK_ADAPTER_STATE", cookie, cookiePath, null, 0, deployment.getSslRequired().isRequired(facade.getRequest().getRemoteAddr()), true);
    }

    static String getCookiePath(KeycloakDeployment deployment, HttpFacade facade) {
        String path;
        String string = path = deployment.getAdapterStateCookiePath() == null ? "" : deployment.getAdapterStateCookiePath().trim();
        if (path.startsWith("/")) {
            return path;
        }
        String contextPath = KeycloakCookieUtils.getContextPath(facade);
        StringBuilder cookiePath = new StringBuilder(contextPath);
        if (!contextPath.endsWith("/") && !path.isEmpty()) {
            cookiePath.append("/");
        }
        return cookiePath.append(path).toString();
    }

    static String getContextPath(HttpFacade facade) {
        String uri = facade.getRequest().getURI();
        String path = KeycloakUriBuilder.fromUri((String)uri).getPath();
        if (path == null || path.isEmpty()) {
            return "/";
        }
        int index = path.indexOf("/", 1);
        return index == -1 ? path : path.substring(0, index);
    }
}

