/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import com.googlecode.genericdao.search.Filter;
import com.googlecode.genericdao.search.ISearch;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class KeycloakSearchMapper {
    private static final List<Integer> SUPPORTED_OPERATORS = Arrays.asList(100, 0, 7, 1);

    KeycloakSearchMapper() {
    }

    KeycloakQuery keycloackQuery(ISearch search) {
        KeycloakQuery query = new KeycloakQuery();
        List filters = (search = this.getNestedSearch(search)).getFilters();
        boolean allSupported = filters.stream().allMatch(f -> SUPPORTED_OPERATORS.contains(f.getOperator()));
        if (!allSupported) {
            throw new UnsupportedOperationException("Keycloak DAO cannot filter for more then one value");
        }
        if (!filters.isEmpty()) {
            for (Filter filter : filters) {
                this.processFilter(query, filter);
            }
        }
        Integer page = search.getPage();
        Integer maxRes = search.getMaxResults();
        if (page > -1) {
            int startIndex;
            int n = startIndex = maxRes != null ? page * maxRes : page;
            if (startIndex > 0) {
                ++startIndex;
            }
            if (maxRes != null) {
                query.setStartIndex(startIndex);
            }
        }
        if (maxRes > -1) {
            query.setMaxResults(maxRes);
        }
        return query;
    }

    private void processFilter(KeycloakQuery query, Filter filter) {
        if (filter.getOperator() == 100) {
            return;
        }
        if (filter.getOperator() == 0) {
            query.setExact(true);
        } else if (filter.getOperator() != 7 && filter.getOperator() != 1) {
            throw new UnsupportedOperationException("Keycloak DAO supports only EQUAL and LIKE operators");
        }
        if (filter.getOperator() == 1 && filter.getValue().toString().equalsIgnoreCase(GroupReservedNames.EVERYONE.groupName())) {
            query.setSkipEveryBodyGroup(true);
        } else {
            FilterType type;
            String property = filter.getProperty().toUpperCase();
            try {
                type = FilterType.valueOf(property);
            }
            catch (UnsupportedOperationException e) {
                type = FilterType.NOT_FOUND;
            }
            switch (type) {
                case NAME: {
                    query.setUserName(filter.getValue().toString());
                    break;
                }
                case GROUPNAME: {
                    query.setGroupName(filter.getValue().toString());
                    break;
                }
                case ENABLED: {
                    query.setEnabled(Boolean.valueOf(filter.getValue().toString()));
                    break;
                }
            }
        }
    }

    protected ISearch getNestedSearch(ISearch search) {
        ArrayList<Filter> newFilters = new ArrayList<Filter>();
        for (Filter filter : search.getFilters()) {
            Filter nestedFilter = this.getNestedFilter(filter);
            if (nestedFilter != null) {
                newFilters.add(nestedFilter);
                continue;
            }
            newFilters.add(filter);
        }
        search.getFilters().clear();
        search.getFilters().addAll(newFilters);
        return search;
    }

    protected Filter getNestedFilter(Filter filter) {
        if (filter.getOperator() == 200 || filter.getOperator() == 201) {
            return (Filter)filter.getValue();
        }
        return null;
    }

    static enum FilterType {
        NAME,
        GROUPNAME,
        ENABLED,
        NOT_FOUND;

    }
}

