/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.web.client.RestTemplate;

public class DiscoveryClient {
    private static final String PROVIDER_END_PATH = "/.well-known/openid-configuration";
    private static final String AUTHORIZATION_ENDPOINT_ATTR_NAME = "authorization_endpoint";
    private static final String TOKEN_ENDPOINT_ATTR_NAME = "token_endpoint";
    private static final String USERINFO_ENDPOINT_ATTR_NAME = "userinfo_endpoint";
    private static final String END_SESSION_ENDPOINT = "end_session_endpoint";
    private static final String JWK_SET_URI_ATTR_NAME = "jwks_uri";
    private static final String SCOPES_SUPPORTED = "scopes_supported";
    private static final String REVOCATION_ENDPOINT = "revocation_endpoint";
    private final RestTemplate restTemplate;
    private String location;

    public DiscoveryClient(String location) {
        this.setLocation(location);
        this.restTemplate = new RestTemplate();
    }

    public DiscoveryClient(String location, RestTemplate restTemplate) {
        this.setLocation(location);
        this.restTemplate = restTemplate;
    }

    private static String appendPath(String ... pathComponents) {
        StringBuilder result = new StringBuilder(pathComponents[0]);
        for (int i = 1; i < pathComponents.length; ++i) {
            String component = pathComponents[i];
            boolean endsWithSlash = result.charAt(result.length() - 1) == '/';
            boolean startsWithSlash = component.startsWith("/");
            if (endsWithSlash && startsWithSlash) {
                result.setLength(result.length() - 1);
            } else if (!endsWithSlash && !startsWithSlash) {
                result.append("/");
            }
            result.append(component);
        }
        return result.toString();
    }

    private void setLocation(String location) {
        if (!location.endsWith(PROVIDER_END_PATH)) {
            location = DiscoveryClient.appendPath(location, PROVIDER_END_PATH);
        }
        this.location = location;
    }

    public void autofill(OAuth2Configuration conf) {
        if (this.location != null) {
            Map response = (Map)this.restTemplate.getForObject(this.location, Map.class, new Object[0]);
            assert (response != null);
            Optional.ofNullable(response.get(this.getAuthorizationEndpointAttrName())).ifPresent(uri -> conf.setAuthorizationUri((String)uri));
            Optional.ofNullable(response.get(this.getTokenEndpointAttrName())).ifPresent(uri -> conf.setAccessTokenUri((String)uri));
            Optional.ofNullable(response.get(this.getUserinfoEndpointAttrName())).ifPresent(uri -> conf.setCheckTokenEndpointUrl((String)uri));
            Optional.ofNullable(response.get(this.getJwkSetUriAttrName())).ifPresent(uri -> conf.setIdTokenUri((String)uri));
            Optional.ofNullable(response.get(this.getEndSessionEndpoint())).ifPresent(uri -> conf.setLogoutUri((String)uri));
            Optional.ofNullable(response.get(this.getRevocationEndpoint())).ifPresent(s -> conf.setRevokeEndpoint((String)s));
            if (conf.getScopes() == null || conf.getScopes().isEmpty()) {
                Optional.ofNullable(response.get(this.getScopesSupported())).ifPresent(s -> {
                    List scopes = (List)s;
                    conf.setScopes(this.collectScopes(scopes));
                });
            }
        }
    }

    private String collectScopes(List<String> scopes) {
        return String.join((CharSequence)",", scopes);
    }

    protected String getUserinfoEndpointAttrName() {
        return USERINFO_ENDPOINT_ATTR_NAME;
    }

    protected String getEndSessionEndpoint() {
        return END_SESSION_ENDPOINT;
    }

    protected String getJwkSetUriAttrName() {
        return JWK_SET_URI_ATTR_NAME;
    }

    protected String getProviderEndPath() {
        return PROVIDER_END_PATH;
    }

    protected String getAuthorizationEndpointAttrName() {
        return AUTHORIZATION_ENDPOINT_ATTR_NAME;
    }

    protected String getTokenEndpointAttrName() {
        return TOKEN_ENDPOINT_ATTR_NAME;
    }

    protected String getScopesSupported() {
        return SCOPES_SUPPORTED;
    }

    protected String getRevocationEndpoint() {
        return REVOCATION_ENDPOINT;
    }
}

