/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.model.SessionToken;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenStorage;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class InMemoryTokenStorage
implements TokenStorage<String> {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final Map<String, SessionToken> sessions = new ConcurrentHashMap<String, SessionToken>();
    private final int cleanUpSeconds = 120;
    private final Runnable evictionTask = new Runnable(){

        @Override
        public void run() {
            for (String sessionId : InMemoryTokenStorage.this.sessions.keySet()) {
                InMemoryTokenStorage.this.removeTokenByIdentifier(sessionId);
            }
        }
    };

    public InMemoryTokenStorage() {
        this.scheduler.scheduleAtFixedRate(this.evictionTask, 120L, 120L, TimeUnit.SECONDS);
    }

    @Override
    public SessionToken getTokenByIdentifier(String identifier) {
        return this.sessions.get(identifier);
    }

    @Override
    public void removeTokenByIdentifier(String identifier) {
        this.sessions.remove(identifier);
    }

    @Override
    public void saveToken(String identifier, SessionToken token) {
        this.sessions.put(identifier, token);
    }

    @Override
    public String buildTokenKey() {
        return UUID.randomUUID().toString();
    }
}

