/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.MapExpressionUserMapper;
import it.geosolutions.geostore.core.security.UserMapper;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.GeoStoreRequestHeadersAuthenticationFilter;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreOAuthRestTemplate;
import it.geosolutions.geostore.services.rest.security.oauth2.JWTHelper;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2GeoStoreAuthenticationFilter;
import it.geosolutions.geostore.services.rest.utils.MockedUserService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class GeoStoreAuthenticationFilterTest {
    private static final String USERNAME_HEADER = "username";
    private static final String SAMPLE_USER = "myuser";
    private MockedUserService userService;
    private GeoStoreRequestHeadersAuthenticationFilter headerFilter;
    private HttpServletRequest req;
    private HttpServletResponse resp;

    @Before
    public void setUp() {
        this.userService = new MockedUserService();
        this.headerFilter = new GeoStoreRequestHeadersAuthenticationFilter();
        this.headerFilter.setUserNameHeader(USERNAME_HEADER);
        this.headerFilter.setUserService((UserService)this.userService);
        this.headerFilter.setAutoCreateUser(true);
        this.req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)this.req.getHeader(USERNAME_HEADER)).thenReturn((Object)SAMPLE_USER);
        Mockito.when((Object)this.req.getHeader("header1")).thenReturn((Object)"value1");
        Mockito.when((Object)this.req.getHeaderNames()).thenReturn(new Vector<String>(Arrays.asList(USERNAME_HEADER, "header1")).elements());
    }

    @After
    public void tearDown() {
        SecurityContextHolder.getContext().setAuthentication(null);
        RequestContextHolder.resetRequestAttributes();
    }

    @Test
    public void testAutoCreate() throws IOException, ServletException, NotFoundServiceEx {
        this.headerFilter.doFilter((ServletRequest)this.req, (ServletResponse)this.resp, new FilterChain(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            }
        });
        User user = this.userService.get(SAMPLE_USER);
        GeoStoreAuthenticationFilterTest.checkUser(user);
        Assert.assertTrue((String)"User should be enabled", (boolean)user.isEnabled());
    }

    @Test
    public void testAutoCreateDisabled() throws IOException, ServletException, NotFoundServiceEx {
        this.headerFilter.setEnableAutoCreatedUsers(false);
        this.headerFilter.doFilter((ServletRequest)this.req, (ServletResponse)this.resp, new FilterChain(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            }
        });
        User user = this.userService.get(SAMPLE_USER);
        GeoStoreAuthenticationFilterTest.checkUser(user);
        Assert.assertFalse((String)"User should be disabled", (boolean)user.isEnabled());
    }

    @Test
    public void testAutoCreateAttributesMapping() throws IOException, ServletException, NotFoundServiceEx {
        this.headerFilter.setUserMapper((UserMapper)new MapExpressionUserMapper(Collections.singletonMap("attr1", "header1")));
        this.headerFilter.doFilter((ServletRequest)this.req, (ServletResponse)this.resp, new FilterChain(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            }
        });
        User user = this.userService.get(SAMPLE_USER);
        GeoStoreAuthenticationFilterTest.checkUser(user);
        Assert.assertNotNull((String)"Attributes should not be null", (Object)user.getAttribute());
        Assert.assertEquals((String)"Should have one attribute", (long)1L, (long)user.getAttribute().size());
        UserAttribute attr = (UserAttribute)user.getAttribute().get(0);
        Assert.assertEquals((String)"Attribute name should be 'attr1'", (Object)"attr1", (Object)attr.getName());
        Assert.assertEquals((String)"Attribute value should be 'value1'", (Object)"value1", (Object)attr.getValue());
    }

    @Test
    public void testUsernameRemapping() throws Exception {
        String ORIGINAL_USERNAME = SAMPLE_USER;
        String REMAPPED_USERNAME = "remappedUser";
        TestOAuth2Configuration config = new TestOAuth2Configuration();
        config.setPrincipalKey("principal");
        config.setUniqueUsername("unique");
        config.setBeanName("testBean");
        config.setAutoCreateUser(true);
        GeoStoreOAuthRestTemplate rt = (GeoStoreOAuthRestTemplate)Mockito.mock(GeoStoreOAuthRestTemplate.class);
        OAuth2ClientContext ctx = (OAuth2ClientContext)Mockito.mock(OAuth2ClientContext.class);
        Mockito.when((Object)ctx.getAccessToken()).thenReturn((Object)new DefaultOAuth2AccessToken("t"));
        Mockito.when((Object)rt.getOAuth2ClientContext()).thenReturn((Object)ctx);
        OAuth2GeoStoreAuthenticationFilter oauth2Filter = new OAuth2GeoStoreAuthenticationFilter(null, rt, config, null){

            protected JWTHelper decodeAndValidateIdToken(String idToken) {
                return new JWTHelper(idToken){

                    public <T> T getClaim(String claimName, Class<T> clazz) {
                        if ("principal".equals(claimName)) {
                            return (T)GeoStoreAuthenticationFilterTest.SAMPLE_USER;
                        }
                        if ("unique".equals(claimName)) {
                            return (T)"remappedUser";
                        }
                        return null;
                    }
                };
            }

            protected User retrieveUserWithAuthorities(String username, HttpServletRequest request, HttpServletResponse response) {
                User user = new User();
                user.setName(username);
                user.setRole(Role.USER);
                user.setEnabled(true);
                user.setAttribute(Collections.emptyList());
                user.setGroups(new HashSet());
                return user;
            }

            protected void configureRestTemplate() {
            }
        };
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse resp = new MockHttpServletResponse();
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)req));
        PreAuthenticatedAuthenticationToken authToken = oauth2Filter.createPreAuthentication(SAMPLE_USER, (HttpServletRequest)req, (HttpServletResponse)resp);
        Assert.assertNotNull((String)"Authentication token should not be null", (Object)authToken);
        User user = (User)authToken.getPrincipal();
        Assert.assertNotNull((String)"User should not be null", (Object)user);
        Assert.assertEquals((String)"Username should be remapped to the unique claim value", (Object)"remappedUser", (Object)user.getName());
    }

    @Test
    public void testGroupNamesUppercaseAndUserGroupAssignment() throws Exception {
        String GROUP_FROM_TOKEN = "groupA";
        String EXPECTED_GROUP = "GROUPA";
        TestOAuth2Configuration config = new TestOAuth2Configuration();
        config.setGroupsClaim("groups");
        config.setBeanName("testBean");
        config.setAutoCreateUser(true);
        config.setGroupNamesUppercase(true);
        DummyUserGroupService dummyGroupService = new DummyUserGroupService();
        GeoStoreOAuthRestTemplate rt = (GeoStoreOAuthRestTemplate)Mockito.mock(GeoStoreOAuthRestTemplate.class);
        OAuth2ClientContext ctx = (OAuth2ClientContext)Mockito.mock(OAuth2ClientContext.class);
        Mockito.when((Object)ctx.getAccessToken()).thenReturn((Object)new DefaultOAuth2AccessToken("t"));
        Mockito.when((Object)rt.getOAuth2ClientContext()).thenReturn((Object)ctx);
        OAuth2GeoStoreAuthenticationFilter oauth2Filter = new OAuth2GeoStoreAuthenticationFilter(null, rt, config, null){

            protected User retrieveUserWithAuthorities(String username, HttpServletRequest request, HttpServletResponse response) {
                User user = new User();
                user.setId(Long.valueOf(1L));
                user.setName(username);
                user.setRole(Role.USER);
                user.setEnabled(true);
                user.setAttribute(Collections.emptyList());
                user.setGroups(new HashSet());
                return user;
            }

            protected void configureRestTemplate() {
            }
        };
        oauth2Filter.setUserGroupService((UserGroupService)dummyGroupService);
        String jwt = GeoStoreAuthenticationFilterTest.unsignedJwtJson("{\"groups\":[\"groupA\"]}");
        MockHttpServletRequest req = new MockHttpServletRequest();
        ServletRequestAttributes attrs = new ServletRequestAttributes((HttpServletRequest)req);
        attrs.setAttribute("OpenIdConnect-IdTokenValue", (Object)jwt, 0);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attrs);
        PreAuthenticatedAuthenticationToken authToken = oauth2Filter.createPreAuthentication("anyuser", (HttpServletRequest)req, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertNotNull((Object)authToken);
        User user = (User)authToken.getPrincipal();
        Assert.assertNotNull((Object)user);
        boolean found = user.getGroups().stream().anyMatch(g -> "GROUPA".equals(g.getGroupName()));
        Assert.assertTrue((String)"User should be assigned to group GROUPA", (boolean)found);
        UserGroup groupFromService = dummyGroupService.get("GROUPA");
        Assert.assertNotNull((String)"Dummy group service should contain group GROUPA", (Object)groupFromService);
        Assert.assertEquals((Object)"testBean", (Object)dummyGroupService.getWithAttributes(groupFromService.getId()).getAttributes().stream().filter(a -> "sourceService".equals(a.getName())).findFirst().orElseThrow().getValue());
    }

    @Test
    public void testRemoteGroupsUpdateProviderScoped() throws Exception {
        GeoStoreOAuthRestTemplate rt = (GeoStoreOAuthRestTemplate)Mockito.mock(GeoStoreOAuthRestTemplate.class);
        OAuth2ClientContext ctx = (OAuth2ClientContext)Mockito.mock(OAuth2ClientContext.class);
        Mockito.when((Object)ctx.getAccessToken()).thenReturn((Object)new DefaultOAuth2AccessToken("oauth2-test-token"));
        Mockito.when((Object)rt.getOAuth2ClientContext()).thenReturn((Object)ctx);
        TestOAuth2Configuration config = new TestOAuth2Configuration();
        config.setGroupsClaim("groups");
        config.setBeanName("testBean");
        config.setAutoCreateUser(true);
        config.setGroupNamesUppercase(true);
        DummyUserGroupService userGroupService = new DummyUserGroupService();
        final User user = new User();
        user.setId(Long.valueOf(1000L));
        user.setRole(Role.USER);
        user.setEnabled(true);
        user.setAttribute(Collections.emptyList());
        UserGroup local = new UserGroup();
        local.setGroupName("local");
        local.setUsers(new ArrayList<User>(Collections.singletonList(user)));
        userGroupService.insert(local);
        UserGroup otherRemote = new UserGroup();
        otherRemote.setGroupName("remote");
        otherRemote.setUsers(new ArrayList<User>(Collections.singletonList(user)));
        userGroupService.insert(otherRemote);
        userGroupService.upsertAttribute(otherRemote.getId(), "sourceService", "other");
        user.setGroups(new HashSet<UserGroup>(Arrays.asList(local, otherRemote)));
        OAuth2GeoStoreAuthenticationFilter filter = new OAuth2GeoStoreAuthenticationFilter(null, rt, config, null){

            protected User retrieveUserWithAuthorities(String username, HttpServletRequest request, HttpServletResponse response) {
                user.setName(username);
                return user;
            }

            protected void configureRestTemplate() {
            }
        };
        filter.setUserGroupService((UserGroupService)userGroupService);
        String jwt = GeoStoreAuthenticationFilterTest.unsignedJwtJson("{\"groups\":[\"admin\",\"developer\"]}");
        MockHttpServletRequest req = new MockHttpServletRequest();
        ServletRequestAttributes attrs = new ServletRequestAttributes((HttpServletRequest)req);
        attrs.setAttribute("OpenIdConnect-IdTokenValue", (Object)jwt, 0);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attrs);
        PreAuthenticatedAuthenticationToken authToken = filter.createPreAuthentication("test-user", (HttpServletRequest)req, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertNotNull((Object)authToken);
        User authenticatedUser = (User)authToken.getPrincipal();
        Assert.assertNotNull((Object)authenticatedUser);
        Set groups = authenticatedUser.getGroups();
        Assert.assertEquals((long)4L, (long)groups.size());
        Map byName = groups.stream().collect(Collectors.toMap(UserGroup::getGroupName, Function.identity()));
        Assert.assertTrue((boolean)byName.containsKey("local"));
        Assert.assertTrue((boolean)byName.containsKey("remote"));
        Assert.assertTrue((boolean)byName.containsKey("ADMIN"));
        Assert.assertTrue((boolean)byName.containsKey("DEVELOPER"));
        Assert.assertEquals((Object)"testBean", (Object)userGroupService.getWithAttributes(((UserGroup)byName.get("ADMIN")).getId()).getAttributes().stream().filter(a -> "sourceService".equals(a.getName())).findFirst().orElseThrow().getValue());
        Assert.assertEquals((Object)"testBean", (Object)userGroupService.getWithAttributes(((UserGroup)byName.get("DEVELOPER")).getId()).getAttributes().stream().filter(a -> "sourceService".equals(a.getName())).findFirst().orElseThrow().getValue());
    }

    @Test
    public void testRemoteGroupsRemovalWhenGroupsEmpty_noLazyAccess() throws Exception {
        GeoStoreOAuthRestTemplate rt = (GeoStoreOAuthRestTemplate)Mockito.mock(GeoStoreOAuthRestTemplate.class);
        OAuth2ClientContext ctx = (OAuth2ClientContext)Mockito.mock(OAuth2ClientContext.class);
        Mockito.when((Object)ctx.getAccessToken()).thenReturn((Object)new DefaultOAuth2AccessToken("oauth2-test-token"));
        Mockito.when((Object)rt.getOAuth2ClientContext()).thenReturn((Object)ctx);
        TestOAuth2Configuration config = new TestOAuth2Configuration();
        config.setGroupsClaim("groups");
        config.setBeanName("testBean");
        config.setAutoCreateUser(true);
        config.setGroupNamesUppercase(true);
        DummyUserGroupService userGroupService = new DummyUserGroupService();
        final User user = new User();
        user.setId(Long.valueOf(2000L));
        user.setRole(Role.USER);
        user.setEnabled(true);
        user.setAttribute(Collections.emptyList());
        ThrowOnAttributesGroup msAdmin = new ThrowOnAttributesGroup();
        msAdmin.setGroupName("MS_ADMIN_GROUP");
        msAdmin.setUsers(new ArrayList<User>(Collections.singletonList(user)));
        userGroupService.insert(msAdmin);
        userGroupService.upsertAttribute(msAdmin.getId(), "sourceService", "testBean");
        UserGroup other = new UserGroup();
        other.setGroupName("OTHER_GROUP");
        other.setUsers(new ArrayList<User>(Collections.singletonList(user)));
        userGroupService.insert(other);
        userGroupService.upsertAttribute(other.getId(), "sourceService", "other");
        UserGroup local = new UserGroup();
        local.setGroupName("LOCAL_GROUP");
        local.setUsers(new ArrayList<User>(Collections.singletonList(user)));
        userGroupService.insert(local);
        user.setGroups(new HashSet<UserGroup>(Arrays.asList(new UserGroup[]{msAdmin, other, local})));
        OAuth2GeoStoreAuthenticationFilter filter = new OAuth2GeoStoreAuthenticationFilter(null, rt, config, null){

            protected User retrieveUserWithAuthorities(String username, HttpServletRequest request, HttpServletResponse response) {
                user.setName(username);
                return user;
            }

            protected void configureRestTemplate() {
            }
        };
        filter.setUserGroupService((UserGroupService)userGroupService);
        String jwt = GeoStoreAuthenticationFilterTest.unsignedJwtJson("{\"groups\":[]}");
        MockHttpServletRequest req = new MockHttpServletRequest();
        ServletRequestAttributes attrs = new ServletRequestAttributes((HttpServletRequest)req);
        attrs.setAttribute("OpenIdConnect-IdTokenValue", (Object)jwt, 0);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attrs);
        PreAuthenticatedAuthenticationToken token = filter.createPreAuthentication("test", (HttpServletRequest)req, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertNotNull((Object)token);
        User u = (User)token.getPrincipal();
        Set groups = u.getGroups().stream().map(UserGroup::getGroupName).collect(Collectors.toSet());
        Assert.assertFalse((boolean)groups.contains("MS_ADMIN_GROUP"));
        Assert.assertTrue((boolean)groups.contains("OTHER_GROUP"));
        Assert.assertTrue((boolean)groups.contains("LOCAL_GROUP"));
    }

    @Test
    public void testRoleResolutionPresentEmptyMissing() throws Exception {
        GeoStoreOAuthRestTemplate rt = (GeoStoreOAuthRestTemplate)Mockito.mock(GeoStoreOAuthRestTemplate.class);
        OAuth2ClientContext ctx = (OAuth2ClientContext)Mockito.mock(OAuth2ClientContext.class);
        Mockito.when((Object)ctx.getAccessToken()).thenReturn((Object)new DefaultOAuth2AccessToken("t"));
        Mockito.when((Object)rt.getOAuth2ClientContext()).thenReturn((Object)ctx);
        TestOAuth2Configuration config = new TestOAuth2Configuration();
        config.setRolesClaim("roles");
        config.setBeanName("testBean");
        config.setAutoCreateUser(true);
        DummyUserGroupService ugs = new DummyUserGroupService();
        final User user = new User();
        user.setId(Long.valueOf(3000L));
        user.setRole(Role.USER);
        user.setEnabled(true);
        user.setAttribute(Collections.emptyList());
        user.setGroups(new HashSet());
        OAuth2GeoStoreAuthenticationFilter filter = new OAuth2GeoStoreAuthenticationFilter(null, rt, config, null){

            protected User retrieveUserWithAuthorities(String username, HttpServletRequest request, HttpServletResponse response) {
                user.setName(username);
                return user;
            }

            protected void configureRestTemplate() {
            }
        };
        filter.setUserGroupService((UserGroupService)ugs);
        GeoStoreAuthenticationFilterTest.setIdToken("{\"roles\":[\"ADMIN\"]}");
        PreAuthenticatedAuthenticationToken t1 = filter.createPreAuthentication("u", (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertEquals((Object)Role.ADMIN, (Object)((User)t1.getPrincipal()).getRole());
        user.setRole(Role.ADMIN);
        GeoStoreAuthenticationFilterTest.setIdToken("{\"roles\":[]}");
        PreAuthenticatedAuthenticationToken t2 = filter.createPreAuthentication("u", (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertEquals((Object)Role.USER, (Object)((User)t2.getPrincipal()).getRole());
        user.setRole(Role.GUEST);
        GeoStoreAuthenticationFilterTest.setIdToken("{\"some\":\"thing\"}");
        PreAuthenticatedAuthenticationToken t3 = filter.createPreAuthentication("u", (HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertEquals((Object)Role.GUEST, (Object)((User)t3.getPrincipal()).getRole());
    }

    @Test
    public void testGetWithAttributes_returnsEagerCopy_noMutationLeak() throws BadRequestServiceEx, NotFoundServiceEx {
        DummyUserGroupService svc = new DummyUserGroupService();
        UserGroup g = new UserGroup();
        g.setGroupName("TEAM");
        ArrayList<UserGroupAttribute> attrs = new ArrayList<UserGroupAttribute>();
        attrs.add(GeoStoreAuthenticationFilterTest.attr("k1", "v1"));
        attrs.add(GeoStoreAuthenticationFilterTest.attr("k2", "v2"));
        g.setAttributes(attrs);
        long id = svc.insert(g);
        Assert.assertTrue((String)"Plain get should not expose attributes (simulates non-eager load)", (svc.get(id).getAttributes() == null || svc.get(id).getAttributes().isEmpty() ? 1 : 0) != 0);
        UserGroup loaded = svc.getWithAttributes(id);
        Assert.assertNotNull((Object)loaded);
        Assert.assertEquals((long)2L, (long)loaded.getAttributes().size());
        loaded.getAttributes().clear();
        Assert.assertEquals((String)"Clearing returned attributes must not affect stored attributes", (long)2L, (long)svc.getWithAttributes(id).getAttributes().size());
    }

    @Test
    public void testUpsertAttribute_insertThenUpdate_caseInsensitive() throws BadRequestServiceEx, NotFoundServiceEx {
        DummyUserGroupService svc = new DummyUserGroupService();
        UserGroup g = new UserGroup();
        g.setGroupName("ORG");
        long id = svc.insert(g);
        svc.upsertAttribute(id, "SourceService", "A");
        UserGroup with1 = svc.getWithAttributes(id);
        Assert.assertEquals((long)1L, (long)with1.getAttributes().size());
        Assert.assertEquals((Object)"A", (Object)((UserGroupAttribute)with1.getAttributes().get(0)).getValue());
        svc.upsertAttribute(id, "sourceservice", "B");
        UserGroup with2 = svc.getWithAttributes(id);
        Assert.assertEquals((long)1L, (long)with2.getAttributes().size());
        Assert.assertEquals((Object)"B", (Object)((UserGroupAttribute)with2.getAttributes().get(0)).getValue());
        Assert.assertEquals((Object)"sourceservice", (Object)((UserGroupAttribute)with2.getAttributes().get(0)).getName());
    }

    private static void checkUser(User user) {
        Assert.assertNotNull((String)"User should not be null", (Object)user);
        Assert.assertEquals((String)"User role should be USER", (Object)Role.USER, (Object)user.getRole());
        Assert.assertTrue((String)"User groups should be empty", (boolean)user.getGroups().isEmpty());
    }

    private static UserGroupAttribute attr(String n, String v) {
        UserGroupAttribute a = new UserGroupAttribute();
        a.setName(n);
        a.setValue(v);
        return a;
    }

    private static String unsignedJwtJson(String payloadJson) {
        String header = "{\"alg\":\"none\"}";
        String encHeader = GeoStoreAuthenticationFilterTest.base64Url(header);
        String encPayload = GeoStoreAuthenticationFilterTest.base64Url(payloadJson);
        return encHeader + "." + encPayload + ".";
    }

    private static String base64Url(String s) {
        byte[] enc = Base64.encodeBase64URLSafe((byte[])s.getBytes(StandardCharsets.UTF_8));
        return new String(enc, StandardCharsets.UTF_8);
    }

    private static void setIdToken(String payloadJson) {
        String jwt = GeoStoreAuthenticationFilterTest.unsignedJwtJson(payloadJson);
        MockHttpServletRequest req = new MockHttpServletRequest();
        ServletRequestAttributes attrs = new ServletRequestAttributes((HttpServletRequest)req);
        attrs.setAttribute("OpenIdConnect-IdTokenValue", (Object)jwt, 0);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attrs);
    }

    private static class DummyUserGroupService
    implements UserGroupService {
        private final Map<String, UserGroup> groupsByName = new HashMap<String, UserGroup>();
        private final Map<Long, UserGroup> groupsById = new HashMap<Long, UserGroup>();
        private final Map<Long, List<UserGroupAttribute>> attrsByGroupId = new HashMap<Long, List<UserGroupAttribute>>();
        private long nextId = 1L;

        private DummyUserGroupService() {
        }

        public UserGroup get(String groupName) {
            return this.groupsByName.get(groupName);
        }

        public long getCount(String nameLike, boolean all) {
            return this.groupsByName.size();
        }

        public long getCount(User authUser, String nameLike, boolean all) {
            return this.groupsByName.size();
        }

        public void updateAttributes(long id, List<UserGroupAttribute> attributes) throws NotFoundServiceEx {
            UserGroup g = this.groupsById.get(id);
            if (g == null) {
                throw new NotFoundServiceEx("group not found");
            }
            this.attrsByGroupId.put(id, DummyUserGroupService.deepCopy(attributes));
            this.groupsByName.put(g.getGroupName(), g);
        }

        public long update(UserGroup group) {
            if (group.getId() == null) {
                group.setId(Long.valueOf(this.nextId++));
            }
            if (group.getAttributes() != null) {
                this.attrsByGroupId.put(group.getId(), DummyUserGroupService.deepCopy(group.getAttributes()));
                group.setAttributes(null);
            }
            this.groupsById.put(group.getId(), group);
            this.groupsByName.put(group.getGroupName(), group);
            return group.getId();
        }

        public Collection<UserGroup> findByAttribute(String name, List<String> values, boolean ignoreCase) {
            ArrayList<UserGroup> out = new ArrayList<UserGroup>();
            block0: for (Map.Entry<Long, List<UserGroupAttribute>> e : this.attrsByGroupId.entrySet()) {
                Long gid = e.getKey();
                List<UserGroupAttribute> list = e.getValue();
                if (list == null) continue;
                for (UserGroupAttribute a : list) {
                    boolean valMatch;
                    boolean bl = ignoreCase ? a.getName() != null && a.getName().equalsIgnoreCase(name) : Objects.equals(a.getName(), name);
                    boolean nameMatch = bl;
                    if (!nameMatch || !(valMatch = values == null || values.isEmpty() || values.stream().anyMatch(v -> ignoreCase ? a.getValue() != null && a.getValue().equalsIgnoreCase((String)v) : Objects.equals(a.getValue(), v)))) continue;
                    out.add(this.groupsById.get(gid));
                    continue block0;
                }
            }
            return out;
        }

        public UserGroup getWithAttributes(long id) throws NotFoundServiceEx, BadRequestServiceEx {
            UserGroup g = this.groupsById.get(id);
            if (g == null) {
                throw new NotFoundServiceEx("UserGroup not found " + id);
            }
            UserGroup copy = new UserGroup();
            copy.setId(g.getId());
            copy.setGroupName(g.getGroupName());
            copy.setDescription(g.getDescription());
            copy.setEnabled(g.isEnabled());
            copy.setUsers(g.getUsers());
            List<UserGroupAttribute> attrs = this.attrsByGroupId.get(id);
            copy.setAttributes(DummyUserGroupService.deepCopy(attrs));
            return copy;
        }

        public void upsertAttribute(long groupId, String name, String value) throws NotFoundServiceEx, BadRequestServiceEx {
            UserGroup g = this.groupsById.get(groupId);
            if (g == null) {
                throw new NotFoundServiceEx("UserGroup not found " + groupId);
            }
            List list = this.attrsByGroupId.computeIfAbsent(groupId, k -> new ArrayList());
            UserGroupAttribute existing = list.stream().filter(a -> a.getName() != null && a.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
            if (existing != null) {
                existing.setName(name);
                existing.setValue(value);
            } else {
                UserGroupAttribute a2 = new UserGroupAttribute();
                a2.setName(name);
                a2.setValue(value);
                list.add(a2);
            }
        }

        public UserGroup get(long id) {
            UserGroup g = this.groupsById.get(id);
            if (g == null) {
                return null;
            }
            UserGroup copy = new UserGroup();
            copy.setId(g.getId());
            copy.setGroupName(g.getGroupName());
            copy.setDescription(g.getDescription());
            copy.setEnabled(g.isEnabled());
            return copy;
        }

        public List<ShortResource> updateSecurityRules(Long groupId, List<Long> resourcesToSet, boolean canRead, boolean canWrite) {
            return List.of();
        }

        public boolean insertSpecialUsersGroups() {
            return false;
        }

        public boolean removeSpecialUsersGroups() {
            return false;
        }

        public long insert(UserGroup group) {
            if (group.getId() == null) {
                group.setId(Long.valueOf(this.nextId++));
            }
            if (group.getAttributes() != null) {
                this.attrsByGroupId.put(group.getId(), DummyUserGroupService.deepCopy(group.getAttributes()));
                group.setAttributes(null);
            }
            this.groupsById.put(group.getId(), group);
            this.groupsByName.put(group.getGroupName(), group);
            return group.getId();
        }

        public boolean delete(long id) {
            this.attrsByGroupId.remove(id);
            UserGroup g = this.groupsById.remove(id);
            if (g != null) {
                this.groupsByName.remove(g.getGroupName());
            }
            return g != null;
        }

        public void assignUserGroup(long userId, long groupId) throws NotFoundServiceEx {
            User u;
            UserGroup g = this.groupsById.get(groupId);
            if (g == null) {
                throw new NotFoundServiceEx("group not found");
            }
            if (g.getUsers() == null) {
                g.setUsers(new ArrayList());
            }
            if ((u = (User)g.getUsers().stream().filter(x -> x.getId() == userId).findFirst().orElse(null)) == null) {
                u = new User();
                u.setId(Long.valueOf(userId));
                u.setGroups(new HashSet());
                u.setEnabled(true);
                u.setName("u" + userId);
                g.getUsers().add(u);
            }
            if (u.getGroups() == null) {
                u.setGroups(new HashSet());
            }
            u.getGroups().add(g);
        }

        public void deassignUserGroup(long userId, long groupId) throws NotFoundServiceEx {
            UserGroup g = this.groupsById.get(groupId);
            if (g == null) {
                throw new NotFoundServiceEx("group not found");
            }
            if (g.getUsers() != null) {
                g.getUsers().removeIf(u -> {
                    if (u.getId() == userId) {
                        if (u.getGroups() != null) {
                            u.getGroups().remove(g);
                        }
                        return true;
                    }
                    return false;
                });
            }
        }

        public List<UserGroup> getAllAllowed(User user, Integer page, Integer entries, String nameLike, boolean all) {
            return new ArrayList<UserGroup>(this.groupsByName.values());
        }

        public List<UserGroup> getAll(Integer page, Integer entries) {
            return new ArrayList<UserGroup>(this.groupsByName.values());
        }

        public List<UserGroup> getAll(Integer page, Integer entries, String nameLike, boolean all) {
            return new ArrayList<UserGroup>(this.groupsByName.values());
        }

        private static List<UserGroupAttribute> deepCopy(List<UserGroupAttribute> src) {
            if (src == null) {
                return null;
            }
            ArrayList<UserGroupAttribute> out = new ArrayList<UserGroupAttribute>(src.size());
            for (UserGroupAttribute a : src) {
                UserGroupAttribute c = new UserGroupAttribute();
                c.setName(a.getName());
                c.setValue(a.getValue());
                out.add(c);
            }
            return out;
        }
    }

    private static class ThrowOnAttributesGroup
    extends UserGroup {
        private ThrowOnAttributesGroup() {
        }

        public List<UserGroupAttribute> getAttributes() {
            throw new AssertionError((Object)"Unexpected lazy attribute access");
        }
    }

    private static class TestOAuth2Configuration
    extends OAuth2Configuration {
        private TestOAuth2Configuration() {
        }

        public String getProvider() {
            return this.getBeanName();
        }
    }
}

