/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import com.google.common.collect.Lists;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.GrantedAuthoritiesMapper;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.HeadersAuthenticationFilter;
import it.geosolutions.geostore.services.rest.utils.GroupMapper;
import it.geosolutions.geostore.services.rest.utils.SpelMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class HeadersAuthenticationFilterTest {
    private static final String SAMPLE_USER = "user";
    private static final String SAMPLE_GROUP1 = "group1";
    private static final String SAMPLE_GROUP2 = "group2";
    private static final String ADMIN_ROLE = "ADMIN";
    private static final String ROLE_GROUP = "MYROLE";
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    FilterChain chain = null;
    private HeadersAuthenticationFilter filter;

    @Before
    public void setUp() {
        SecurityContextHolder.getContext().setAuthentication(null);
        this.filter = new HeadersAuthenticationFilter();
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.chain = (FilterChain)Mockito.mock(FilterChain.class);
    }

    @After
    public void tearDown() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @Test
    public void usernameHeaderAuthentication() throws IOException, ServletException, BadRequestServiceEx, NotFoundServiceEx {
        Mockito.when((Object)this.request.getHeader("x-geostore-user")).thenReturn((Object)SAMPLE_USER);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        User authUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Assert.assertEquals((Object)SAMPLE_USER, (Object)authUser.getName());
        Assert.assertNotNull((Object)authUser.getId());
    }

    @Test
    public void noAuthenticationWithoutUsernameHeader() throws IOException, ServletException, BadRequestServiceEx, NotFoundServiceEx {
        Mockito.when((Object)this.request.getHeader("x-geostore-user")).thenReturn(null);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void usernameAndGroupsHeaderAuthentication() throws IOException, ServletException, BadRequestServiceEx, NotFoundServiceEx {
        Mockito.when((Object)this.request.getHeader("x-geostore-user")).thenReturn((Object)SAMPLE_USER);
        Mockito.when((Object)this.request.getHeader("x-geostore-groups")).thenReturn((Object)"group1,group2");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        User authUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Assert.assertEquals((long)2L, (long)authUser.getGroups().size());
    }

    @Test
    public void defaultNoPrefixedGroupsHeaderAuthentication() throws IOException, ServletException, BadRequestServiceEx, NotFoundServiceEx {
        Mockito.when((Object)this.request.getHeader("x-geostore-user")).thenReturn((Object)SAMPLE_USER);
        Mockito.when((Object)this.request.getHeader("x-geostore-groups")).thenReturn((Object)"group1,ROLE_group2");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        User authUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Assert.assertEquals((long)2L, (long)authUser.getGroups().size());
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(SAMPLE_GROUP1);
        groups.add("ROLE_group2");
        for (UserGroup ug : authUser.getGroups()) {
            Assert.assertTrue((boolean)groups.contains(ug.getGroupName()));
        }
    }

    @Test
    public void prefixedGroupsHeaderAuthentication() throws IOException, ServletException, BadRequestServiceEx, NotFoundServiceEx {
        this.filter.setGroupMapper((GroupMapper)new SpelMapper("name.replace('ROLE_', '')"));
        Mockito.when((Object)this.request.getHeader("x-geostore-user")).thenReturn((Object)SAMPLE_USER);
        Mockito.when((Object)this.request.getHeader("x-geostore-groups")).thenReturn((Object)"group1,ROLE_group2");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        User authUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Assert.assertEquals((long)2L, (long)authUser.getGroups().size());
        ArrayList<String> groups = new ArrayList<String>();
        groups.add(SAMPLE_GROUP1);
        groups.add(SAMPLE_GROUP2);
        for (UserGroup ug : authUser.getGroups()) {
            Assert.assertTrue((boolean)groups.contains(ug.getGroupName()));
        }
    }

    @Test
    public void usernameAndRoleHeaderAuthentication() throws IOException, ServletException, BadRequestServiceEx, NotFoundServiceEx {
        Mockito.when((Object)this.request.getHeader("x-geostore-user")).thenReturn((Object)SAMPLE_USER);
        Mockito.when((Object)this.request.getHeader("x-geostore-role")).thenReturn((Object)ADMIN_ROLE);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        User authUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Assert.assertEquals((Object)Role.ADMIN, (Object)authUser.getRole());
        Assert.assertEquals((long)1L, (long)SecurityContextHolder.getContext().getAuthentication().getAuthorities().size());
        Assert.assertEquals((Object)"ROLE_ADMIN", (Object)((GrantedAuthority)SecurityContextHolder.getContext().getAuthentication().getAuthorities().iterator().next()).getAuthority());
    }

    @Test
    public void rolesMapper() throws IOException, ServletException, BadRequestServiceEx, NotFoundServiceEx {
        Mockito.when((Object)this.request.getHeader("x-geostore-user")).thenReturn((Object)SAMPLE_USER);
        Mockito.when((Object)this.request.getHeader("x-geostore-groups")).thenReturn((Object)ROLE_GROUP);
        this.filter.setAuthoritiesMapper(new GrantedAuthoritiesMapper(){

            public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
                for (GrantedAuthority grantedAuthority : authorities) {
                    if (!HeadersAuthenticationFilterTest.ROLE_GROUP.equals(grantedAuthority.getAuthority())) continue;
                    return Lists.newArrayList((Object[])new SimpleGrantedAuthority[]{new SimpleGrantedAuthority(HeadersAuthenticationFilterTest.ADMIN_ROLE)});
                }
                return Lists.newArrayList();
            }
        });
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        User authUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Assert.assertEquals((Object)Role.ADMIN, (Object)authUser.getRole());
        Assert.assertEquals((long)1L, (long)SecurityContextHolder.getContext().getAuthentication().getAuthorities().size());
        Assert.assertEquals((Object)"ROLE_ADMIN", (Object)((GrantedAuthority)SecurityContextHolder.getContext().getAuthentication().getAuthorities().iterator().next()).getAuthority());
    }
}

