/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.UserMapper;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.GroupsRolesService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapUserDetails;

public class UserLdapAuthenticationProvider
extends LdapAuthenticationProvider {
    private static final Logger LOGGER = LogManager.getLogger(UserLdapAuthenticationProvider.class);
    private static final String USER_NOT_FOUND_MSG = "User not found. Please check your credentials";
    private static final String UNAUTHORIZED_MSG = "Bad credentials";
    @Autowired
    UserService userService;
    @Autowired
    UserGroupService userGroupService;
    private UserMapper userMapper;
    @Value(value="${geostoreLdapProvider.ignoreUsernameCase:false}")
    private boolean ignoreUsernameCase;

    public UserLdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator) {
        super(authenticator, authoritiesPopulator);
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setUserGroupService(UserGroupService userGroupService) {
        this.userGroupService = userGroupService;
    }

    public void setUserMapper(UserMapper userMapper) {
        this.userMapper = userMapper;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication = this.ldapAuthentication(authentication)).isAuthenticated()) {
            throw new BadCredentialsException(UNAUTHORIZED_MSG);
        }
        LdapUserDetails ldapUser = (LdapUserDetails)authentication.getPrincipal();
        if (this.userShouldNotAuthenticate(ldapUser)) {
            throw new DisabledException(USER_NOT_FOUND_MSG);
        }
        String ldapUserUsername = this.normalizeUsername(ldapUser.getUsername());
        User user = this.findUser(ldapUserUsername);
        try {
            String pw = (String)authentication.getCredentials();
            Collection ldapAuthorities = ldapUser.getAuthorities();
            if (user != null) {
                return this.authenticateExistingUser(user, pw, ldapAuthorities);
            }
            return this.authenticateNewUser(ldapUserUsername, ldapAuthorities, ldapUser, pw);
        }
        catch (BadRequestServiceEx | NotFoundServiceEx e) {
            LOGGER.log(Level.ERROR, e.getMessage(), e);
            throw new UsernameNotFoundException(USER_NOT_FOUND_MSG);
        }
    }

    private Authentication ldapAuthentication(Authentication authentication) {
        try {
            authentication = super.authenticate(authentication);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new BadCredentialsException(UNAUTHORIZED_MSG);
        }
        return authentication;
    }

    private boolean userShouldNotAuthenticate(LdapUserDetails ldapUser) {
        return !ldapUser.isAccountNonExpired() || !ldapUser.isAccountNonLocked() || !ldapUser.isCredentialsNonExpired() || !ldapUser.isEnabled();
    }

    private String normalizeUsername(String raw) {
        if (raw == null) {
            return null;
        }
        String s = raw.trim();
        return this.ignoreUsernameCase ? s.toUpperCase(Locale.ROOT) : s;
    }

    private User findUser(String normalizedName) {
        try {
            User user = this.userService.get(normalizedName);
            LOGGER.info("User lookup hit for '{}'", (Object)normalizedName);
            if (!user.isEnabled()) {
                throw new DisabledException(USER_NOT_FOUND_MSG);
            }
            return user;
        }
        catch (NotFoundServiceEx notFound) {
            User ci;
            if (this.ignoreUsernameCase && (ci = this.findUserIgnoreCase(normalizedName)) != null) {
                if (!normalizedName.equals(ci.getName())) {
                    LOGGER.warn("Found legacy user '{}' (case-variant), normalizing to '{}'", (Object)ci.getName(), (Object)normalizedName);
                    ci.setName(normalizedName);
                }
                if (!ci.isEnabled()) {
                    throw new DisabledException(USER_NOT_FOUND_MSG);
                }
                return ci;
            }
            LOGGER.info("User not found with name: {}", (Object)normalizedName);
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Error while looking up user '{}'", (Object)normalizedName, (Object)e);
            return null;
        }
    }

    protected User findUserIgnoreCase(String normalizedUpperName) {
        try {
            List candidates = this.userService.getAll(null, null, normalizedUpperName, false);
            if (candidates == null || candidates.isEmpty()) {
                return null;
            }
            return candidates.stream().filter(u -> u.getName() != null && u.getName().trim().equalsIgnoreCase(normalizedUpperName)).min(Comparator.comparing(User::getId)).orElse(null);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "CI lookup failed for '{}'", (Object)normalizedUpperName, (Object)e);
            return null;
        }
    }

    private Authentication authenticateExistingUser(User user, String pw, Collection<? extends GrantedAuthority> ldapAuthorities) throws BadRequestServiceEx, NotFoundServiceEx {
        this.setUserRoleAndGroups(user, ldapAuthorities);
        if (this.userService != null) {
            this.userService.update(user);
        }
        return this.prepareAuthentication(pw, user);
    }

    private Authentication authenticateNewUser(String ldapUserUsername, Collection<? extends GrantedAuthority> ldapAuthorities, LdapUserDetails ldapUser, String pw) throws BadRequestServiceEx, NotFoundServiceEx {
        User user = new User();
        user.setName(ldapUserUsername);
        user.setNewPassword(null);
        user.setEnabled(true);
        this.setUserRoleAndGroups(user, ldapAuthorities);
        if (this.userMapper != null) {
            this.userMapper.mapUser((Object)ldapUser, user);
        }
        if (this.userService != null) {
            this.userService.insert(user);
        }
        return this.prepareAuthentication(pw, user);
    }

    private void setUserRoleAndGroups(User user, Collection<? extends GrantedAuthority> ldapAuthorities) throws BadRequestServiceEx {
        HashSet<UserGroup> groups = new HashSet<UserGroup>();
        Role role = this.extractUserRoleAndGroups(user.getRole(), ldapAuthorities, groups);
        user.setRole(role);
        user.setGroups(GroupReservedNames.checkReservedGroups(groups));
    }

    protected Role extractUserRoleAndGroups(Role userRole, Collection<? extends GrantedAuthority> ldapAuthorities, Set<UserGroup> groups) throws BadRequestServiceEx {
        Role role = userRole != null ? userRole : Role.USER;
        for (GrantedAuthority grantedAuthority : ldapAuthorities) {
            if (grantedAuthority.getAuthority().startsWith("ROLE_")) {
                if (grantedAuthority.getAuthority().toUpperCase().endsWith("ADMIN") && (role == Role.GUEST || role == Role.USER)) {
                    role = Role.ADMIN;
                    continue;
                }
                if (!grantedAuthority.getAuthority().toUpperCase().endsWith("USER") || role != Role.GUEST) continue;
                role = Role.USER;
                continue;
            }
            groups.add(this.synchronizeGroup(grantedAuthority));
        }
        return role;
    }

    protected Authentication prepareAuthentication(String pw, User user) {
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_" + String.valueOf(user.getRole())));
        return new UsernamePasswordAuthenticationToken((Object)user, (Object)pw, grantedAuthorities);
    }

    public void synchronizeGroups() throws BadRequestServiceEx {
        if (this.getAuthoritiesPopulator() instanceof GroupsRolesService) {
            GroupsRolesService groupsService = (GroupsRolesService)this.getAuthoritiesPopulator();
            for (GrantedAuthority authority : groupsService.getAllGroups()) {
                this.synchronizeGroup(authority);
            }
        }
    }

    private UserGroup synchronizeGroup(GrantedAuthority a) throws BadRequestServiceEx {
        UserGroup group = new UserGroup();
        group.setGroupName(a.getAuthority());
        if (this.userGroupService != null) {
            UserGroup userGroup = this.userGroupService.get(group.getGroupName());
            if (userGroup == null) {
                LOGGER.log(Level.INFO, "Creating new group from LDAP: " + group.getGroupName());
                long groupId = this.userGroupService.insert(group);
                userGroup = this.userGroupService.get(groupId);
            }
            return userGroup;
        }
        return group;
    }
}

