/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import com.googlecode.genericdao.search.ISearch;
import it.geosolutions.geostore.services.rest.security.keycloak.GeoStoreKeycloakAuthoritiesMapper;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakAdminClientConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakQuery;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakSearchMapper;
import it.geosolutions.geostore.services.rest.utils.GeoStoreContext;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UsersResource;

public abstract class BaseKeycloakDAO {
    protected KeycloakAdminClientConfiguration adminClientConfiguration;

    public BaseKeycloakDAO(KeycloakAdminClientConfiguration adminClientConfiguration) {
        this.adminClientConfiguration = adminClientConfiguration;
    }

    protected KeycloakQuery toKeycloakQuery(ISearch search) {
        return new KeycloakSearchMapper().keycloackQuery(search);
    }

    protected Keycloak keycloak() {
        return this.adminClientConfiguration.getKeycloak();
    }

    protected UsersResource getUsersResource(Keycloak keycloak) {
        return keycloak.realm(this.adminClientConfiguration.getRealm()).users();
    }

    protected RolesResource getRolesResource(Keycloak keycloak) {
        return keycloak.realm(this.adminClientConfiguration.getRealm()).roles();
    }

    protected void close(Keycloak keycloak) {
        if (keycloak.isClosed()) {
            keycloak.close();
        }
    }

    protected GeoStoreKeycloakAuthoritiesMapper getAuthoritiesMapper() {
        KeyCloakConfiguration configuration = GeoStoreContext.bean(KeyCloakConfiguration.class);
        if (configuration != null) {
            return new GeoStoreKeycloakAuthoritiesMapper(configuration.getRoleMappings(), configuration.getGroupMappings(), configuration.isDropUnmapped());
        }
        return new GeoStoreKeycloakAuthoritiesMapper(null, null, false);
    }
}

