/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.keycloak.GeoStoreKeycloakAuthProvider;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakFilter;
import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakHelper;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakAdminClientConfiguration;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="keycloakConfig")
public class KeyCloakSecurityConfiguration {
    public static final String CACHE_BEAN_NAME = "keycloakCache";
    static final String CONF_BEAN_NAME = "keycloakOAuth2Config";

    @Bean(value={"keycloakOAuth2Config"})
    public KeyCloakConfiguration keycloakConfiguration() {
        return new KeyCloakConfiguration();
    }

    @Bean
    public KeycloakAdminClientConfiguration keycloakRESTClient() {
        return new KeycloakAdminClientConfiguration();
    }

    @Bean
    public KeyCloakFilter keycloakFilter() {
        return new KeyCloakFilter(this.keyCloakHelper(), this.keycloakCache(), this.keycloakConfiguration(), this.keycloakAuthenticationProvider());
    }

    @Bean
    public GeoStoreKeycloakAuthProvider keycloakAuthenticationProvider() {
        return new GeoStoreKeycloakAuthProvider(this.keycloakConfiguration());
    }

    @Bean(value={"keycloakCache"})
    public TokenAuthenticationCache keycloakCache() {
        return new TokenAuthenticationCache();
    }

    @Bean
    public AdapterDeploymentContext keycloackContext() {
        AdapterDeploymentContext context;
        AdapterConfig config = this.keycloakConfiguration().readAdapterConfig();
        if (config != null) {
            KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((AdapterConfig)config);
            context = new AdapterDeploymentContext(deployment);
        } else {
            context = new AdapterDeploymentContext();
        }
        return context;
    }

    @Bean
    public KeyCloakHelper keyCloakHelper() {
        return new KeyCloakHelper(this.keycloackContext());
    }
}

