/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

class KeycloakAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private final AuthChallenge challenge;

    KeycloakAuthenticationEntryPoint(AuthChallenge challenge) {
        this.challenge = challenge;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (this.challenge == null) {
            throw new RuntimeException("Keycloak config is bearer only. No redirect to authorization page can be performed.");
        }
        this.challenge.challenge((HttpFacade)new SimpleHttpFacade(request, response));
        response.sendRedirect(response.getHeader("Location"));
    }
}

