/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import com.google.common.collect.Lists;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.password.SecurityUtils;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreOAuthRestTemplate;
import it.geosolutions.geostore.services.rest.security.oauth2.JWTHelper;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenDetails;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class OAuth2GeoStoreAuthenticationFilter
extends OAuth2ClientAuthenticationProcessingFilter {
    private static final Logger LOGGER = LogManager.getLogger(OAuth2GeoStoreAuthenticationFilter.class);
    private static final String SOURCE_SERVICE_USER_GROUP_ATTRIBUTE_NAME = "sourceService";
    public static final String OAUTH2_AUTHENTICATION_KEY = "oauth2.authentication";
    public static final String OAUTH2_AUTHENTICATION_TYPE_KEY = "oauth2.authenticationType";
    public static final String OAUTH2_ACCESS_TOKEN_CHECK_KEY = "oauth2.AccessTokenCheckResponse";
    private final AuthenticationEntryPoint authEntryPoint;
    private final TokenAuthenticationCache cache;
    @Autowired
    protected UserService userService;
    @Autowired
    protected UserGroupService userGroupService;
    protected RemoteTokenServices tokenServices;
    protected OAuth2Configuration configuration;

    public OAuth2GeoStoreAuthenticationFilter(RemoteTokenServices tokenServices, GeoStoreOAuthRestTemplate oAuth2RestTemplate, OAuth2Configuration configuration, TokenAuthenticationCache tokenAuthenticationCache) {
        super("/**");
        super.setTokenServices((ResourceServerTokenServices)tokenServices);
        this.tokenServices = tokenServices;
        this.restTemplate = oAuth2RestTemplate;
        this.configuration = configuration;
        this.authEntryPoint = configuration.getAuthenticationEntryPoint();
        this.cache = tokenAuthenticationCache;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public UserGroupService getUserGroupService() {
        return this.userGroupService;
    }

    public void setUserGroupService(UserGroupService userGroupService) {
        this.userGroupService = userGroupService;
    }

    public RemoteTokenServices getTokenServices() {
        return this.tokenServices;
    }

    public void setTokenServices(RemoteTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public OAuth2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAuth2Configuration configuration) {
        this.configuration = configuration;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (this.configuration.isEnabled() && !this.configuration.isInvalid() && authentication == null) {
            super.doFilter(req, res, chain);
        } else if (req instanceof HttpServletRequest) {
            this.addRequestAttributes((HttpServletRequest)req, authentication);
        }
        if (this.configuration.isEnabled() && this.configuration.isInvalid()) {
            LOGGER.info("Skipping configured OAuth2 authentication. One or more mandatory properties are missing (clientId, clientSecret, authorizationUri, tokenUri).");
        }
        chain.doFilter(req, res);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        Authentication authentication;
        String token = OAuth2Utils.tokenFromParamsOrBearer("access_token", request);
        if (token != null) {
            request.setAttribute(OAUTH2_AUTHENTICATION_TYPE_KEY, (Object)OAuth2AuthenticationType.BEARER);
        } else {
            request.setAttribute(OAUTH2_AUTHENTICATION_TYPE_KEY, (Object)OAuth2AuthenticationType.USER);
        }
        if (token != null) {
            authentication = this.cache.get(token);
            if (authentication == null) {
                authentication = this.authenticateAndUpdateCache(request, response, token, (OAuth2AccessToken)new DefaultOAuth2AccessToken(token));
            } else {
                OAuth2AccessToken accessToken;
                TokenDetails details = this.tokenDetails(authentication);
                if (details != null && (accessToken = details.getAccessToken()).isExpired()) {
                    authentication = this.authenticateAndUpdateCache(request, response, token, accessToken);
                }
            }
        } else {
            this.clearState();
            authentication = this.authenticateAndUpdateCache(request, response, null, null);
            token = (String)Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).getAttribute("access_token", 0);
            if (token != null) {
                request.setAttribute("access_token", (Object)token);
                request.setAttribute(OAUTH2_AUTHENTICATION_TYPE_KEY, (Object)OAuth2AuthenticationType.BEARER);
                request.setAttribute("id_token", RequestContextHolder.getRequestAttributes().getAttribute("id_token", 0));
                request.setAttribute("refresh_token", RequestContextHolder.getRequestAttributes().getAttribute("refresh_token", 0));
            }
        }
        return authentication;
    }

    private TokenDetails tokenDetails(Authentication authentication) {
        Object details = authentication != null ? authentication.getDetails() : null;
        return details instanceof TokenDetails ? (TokenDetails)details : null;
    }

    private Authentication authenticateAndUpdateCache(HttpServletRequest request, HttpServletResponse response, String token, OAuth2AccessToken accessToken) {
        Authentication authentication = this.performOAuthAuthentication(request, response, accessToken);
        if (authentication != null) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
            TokenDetails tokenDetails = this.tokenDetails(authentication);
            if (tokenDetails != null) {
                OAuth2AccessToken accessTokenDetails = tokenDetails.getAccessToken();
                if (accessTokenDetails != null) {
                    token = accessTokenDetails.getValue();
                    Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).setAttribute("access_token", (Object)accessTokenDetails.getValue(), 0);
                    if (accessTokenDetails.getRefreshToken() != null && accessTokenDetails.getRefreshToken().getValue() != null) {
                        RequestContextHolder.getRequestAttributes().setAttribute("refresh_token", (Object)accessTokenDetails.getRefreshToken().getValue(), 0);
                    }
                }
                if (tokenDetails.getIdToken() != null) {
                    Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).setAttribute("id_token", (Object)tokenDetails.getIdToken(), 0);
                }
            }
            if (token != null) {
                this.cache.putCacheEntry(token, authentication);
            } else {
                LOGGER.info("Skipping cache insert: no access token available yet.");
            }
        }
        Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).setAttribute("PROVIDER", (Object)this.configuration.getProvider(), 0);
        return authentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearState() {
        OAuth2ClientContext clientContext = this.restTemplate.getOAuth2ClientContext();
        AccessTokenRequest accessTokenRequest = clientContext.getAccessTokenRequest();
        if (accessTokenRequest != null && accessTokenRequest.getStateKey() != null) {
            clientContext.removePreservedState(accessTokenRequest.getStateKey());
        }
        if (accessTokenRequest != null) {
            try {
                accessTokenRequest.remove((Object)"access_token");
            }
            finally {
                SecurityContextHolder.clearContext();
                HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
                HttpSession session = request.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
                LOGGER.info("Cleaned out Session Access Token Request!");
            }
        }
    }

    protected Authentication performOAuthAuthentication(HttpServletRequest request, HttpServletResponse response, OAuth2AccessToken accessToken) {
        LOGGER.info("About to perform remote authentication.");
        LOGGER.info("Access Token: {}", (Object)accessToken);
        String principal = null;
        PreAuthenticatedAuthenticationToken result = null;
        try {
            LOGGER.info("Trying to get the pre-authenticated principal.");
            principal = this.getPreAuthenticatedPrincipal(request, response, accessToken);
        }
        catch (IOException | ServletException e1) {
            LOGGER.error("Error obtaining pre-authenticated principal: {}", (Object)e1.getMessage(), (Object)e1);
        }
        LOGGER.info("Pre-authenticated principal = {}, trying to authenticate", (Object)principal);
        if (StringUtils.isNotBlank((CharSequence)principal)) {
            result = this.createPreAuthentication(principal, request, response);
        }
        return result;
    }

    protected String getPreAuthenticatedPrincipal(HttpServletRequest req, HttpServletResponse resp, OAuth2AccessToken accessToken) throws IOException, ServletException {
        JWTHelper helper;
        Map ext;
        String username;
        LOGGER.info("Configuring the REST Resource Template");
        this.configureRestTemplate();
        if (accessToken != null && StringUtils.isNotEmpty((CharSequence)accessToken.getValue())) {
            LOGGER.info("Setting the access token on the OAuth2ClientContext");
            this.restTemplate.getOAuth2ClientContext().setAccessToken(accessToken);
        }
        LOGGER.info("Setting up OAuth2 Filter services and resource template");
        this.setRestTemplate(this.restTemplate);
        this.setTokenServices(this.tokenServices);
        Authentication authentication = null;
        try {
            OAuth2Authentication oAuth2Authentication;
            Object map;
            authentication = super.attemptAuthentication(req, resp);
            req.setAttribute(OAUTH2_AUTHENTICATION_KEY, (Object)authentication);
            if (authentication instanceof OAuth2Authentication) {
                OAuth2Authentication oa = (OAuth2Authentication)authentication;
                LOGGER.info("isClientOnly={}, userAuth={}", (Object)oa.isClientOnly(), (Object)oa.getUserAuthentication());
            }
            if (authentication instanceof OAuth2Authentication && (map = (oAuth2Authentication = (OAuth2Authentication)authentication).getOAuth2Request().getExtensions().get(OAUTH2_ACCESS_TOKEN_CHECK_KEY)) instanceof Map) {
                req.setAttribute(OAUTH2_ACCESS_TOKEN_CHECK_KEY, map);
            }
            if (authentication != null) {
                LOGGER.info("Authenticated OAuth request for principal {}", authentication.getPrincipal());
            }
        }
        catch (Exception e) {
            this.handleOAuthException(e, req, resp);
        }
        String string = username = authentication != null ? SecurityUtils.getUsername((Object)authentication.getPrincipal()) : null;
        if (StringUtils.isNotBlank((CharSequence)username)) {
            LOGGER.info("Authenticated OAuth request with user (security principal) {}", (Object)username);
            return username;
        }
        String fromExt = null;
        Object extObj = req.getAttribute(OAUTH2_ACCESS_TOKEN_CHECK_KEY);
        if (extObj instanceof Map && StringUtils.isBlank((CharSequence)(fromExt = this.coalesce(this.findFirstIgnoreCase(ext = (Map)extObj, this.configuration.getUniqueUsername()), this.findFirstIgnoreCase(ext, this.configuration.getPrincipalKey()))))) {
            fromExt = this.coalesce(this.findFirstIgnoreCase(ext, "upn"), this.findFirstIgnoreCase(ext, "preferred_username"), this.findFirstIgnoreCase(ext, "unique_name"), this.findFirstIgnoreCase(ext, "user_name"), this.findFirstIgnoreCase(ext, "username"), this.findFirstIgnoreCase(ext, "email"), this.findFirstIgnoreCase(ext, "sub"), this.findFirstIgnoreCase(ext, "oid"));
        }
        if (StringUtils.isNotBlank(fromExt)) {
            LOGGER.info("Authenticated OAuth request with user (introspection) {}", fromExt);
            return fromExt;
        }
        String idToken = OAuth2Utils.getIdToken();
        String jwtForClaims = idToken;
        if (jwtForClaims == null && accessToken != null) {
            jwtForClaims = accessToken.getValue();
        }
        if (jwtForClaims == null) {
            jwtForClaims = OAuth2Utils.tokenFromParamsOrBearer("access_token", req);
        }
        if (StringUtils.isNotBlank((CharSequence)jwtForClaims) && (helper = this.decodeAndValidateJwt(jwtForClaims)) != null) {
            String fromJwt = this.coalesce(this.getClaim(helper, this.configuration.getUniqueUsername()), this.getClaim(helper, this.configuration.getPrincipalKey()));
            if (StringUtils.isBlank((CharSequence)fromJwt)) {
                fromJwt = this.coalesce(this.getClaim(helper, "upn"), this.getClaim(helper, "preferred_username"), this.getClaim(helper, "unique_name"), this.getClaim(helper, "email"), this.getClaim(helper, "sub"), this.getClaim(helper, "oid"));
            }
            if (StringUtils.isNotBlank((CharSequence)fromJwt)) {
                LOGGER.info("Authenticated OAuth request with user (JWT claims) {}", (Object)fromJwt);
                return fromJwt;
            }
        }
        LOGGER.warn("Principal could not be resolved from security principal, introspection, or JWT claims.");
        return null;
    }

    private String coalesce(String ... values) {
        if (values == null) {
            return null;
        }
        for (String v : values) {
            if (!StringUtils.isNotBlank((CharSequence)v)) continue;
            return v;
        }
        return null;
    }

    private String getClaim(JWTHelper helper, String key) {
        if (helper == null || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        try {
            return helper.getClaim(key, String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String findFirstIgnoreCase(Map<String, Object> map, String key) {
        if (map == null || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (!key.equalsIgnoreCase(String.valueOf(e.getKey()))) continue;
            return e.getValue() != null ? String.valueOf(e.getValue()) : null;
        }
        for (Object v : map.values()) {
            String found;
            if (!(v instanceof Map) || !StringUtils.isNotBlank((CharSequence)(found = this.findFirstIgnoreCase((Map)v, key)))) continue;
            return found;
        }
        return null;
    }

    private void handleOAuthException(Exception e, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (e instanceof UserRedirectRequiredException && this.configuration.isEnableRedirectEntryPoint()) {
            this.handleUserRedirection(req, resp);
        } else if (e instanceof BadCredentialsException || e instanceof ResourceAccessException) {
            if (e.getCause() instanceof OAuth2AccessDeniedException) {
                LOGGER.warn("Error while trying to authenticate to OAuth2 Provider. Cause: ", e.getCause());
            } else if (e instanceof ResourceAccessException) {
                LOGGER.error("Could not authorize OAuth2 Resource due to exception: ", (Throwable)e);
            } else if (e.getCause() instanceof OAuth2AccessDeniedException) {
                LOGGER.warn("If you try to validate credentials against an SSH protected endpoint, you need your server exposed on a secure SSL channel or OAuth2 Provider Certificate to be trusted on your JVM.");
                LOGGER.info("Refer to the GeoServer OAuth2 Plugin Documentation for steps to import SSH certificates.");
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.error("Could not authorize OAuth2 Resource due to exception: ", (Throwable)e);
            }
        }
    }

    private void handleUserRedirection(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        AccessTokenRequest accessTokenRequest;
        if (req.getRequestURI().contains(this.configuration.getProvider() + "/login")) {
            this.authEntryPoint.commence(req, resp, null);
        } else if (resp.getStatus() != 302 && (accessTokenRequest = this.restTemplate.getOAuth2ClientContext().getAccessTokenRequest()).getPreservedState() != null && accessTokenRequest.getStateKey() != null) {
            accessTokenRequest.remove((Object)"state");
            accessTokenRequest.remove((Object)accessTokenRequest.getStateKey());
            accessTokenRequest.setPreservedState(null);
        }
    }

    protected void configureRestTemplate() {
        AuthorizationCodeResourceDetails details = (AuthorizationCodeResourceDetails)this.restTemplate.getResource();
        details.setClientId(this.configuration.getClientId());
        details.setClientSecret(this.configuration.getClientSecret());
        this.tokenServices.setClientId(this.configuration.getClientId());
        this.tokenServices.setClientSecret(this.configuration.getClientSecret());
        details.setAccessTokenUri(this.configuration.getAccessTokenUri());
        details.setUserAuthorizationUri(this.configuration.getAuthorizationUri());
        details.setPreEstablishedRedirectUri(this.configuration.getRedirectUri());
        this.tokenServices.setCheckTokenEndpointUrl(this.configuration.getCheckTokenEndpointUrl());
        String scopesJoined = this.configuration.getScopes() == null ? "" : Stream.of(this.configuration.getScopes()).collect(Collectors.joining(","));
        details.setScope(this.parseScopes(scopesJoined));
    }

    protected List<String> parseScopes(String commaSeparatedScopes) {
        ArrayList scopes = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)commaSeparatedScopes)) {
            return scopes;
        }
        Collections.addAll(scopes, commaSeparatedScopes.split(","));
        return scopes;
    }

    public PreAuthenticatedAuthenticationToken createPreAuthentication(String username, HttpServletRequest request, HttpServletResponse response) {
        String tokenForClaims;
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.error("Cannot create authentication: empty username.");
            return null;
        }
        LOGGER.info("Retrieving user with authorities for username: {}", (Object)username);
        User user = this.retrieveUserWithAuthorities(username, request, response);
        if (user == null) {
            LOGGER.error("User retrieval failed for username: {}", (Object)username);
            return null;
        }
        SimpleGrantedAuthority authority = new SimpleGrantedAuthority("ROLE_" + user.getRole().toString());
        PreAuthenticatedAuthenticationToken authenticationToken = new PreAuthenticatedAuthenticationToken((Object)user, null, Collections.singletonList(authority));
        String idToken = OAuth2Utils.getIdToken();
        OAuth2AccessToken accessToken = null;
        try {
            accessToken = this.restTemplate.getOAuth2ClientContext().getAccessToken();
        }
        catch (Exception e) {
            LOGGER.debug("No access token in context yet.", (Throwable)e);
        }
        String string = idToken != null ? idToken : (tokenForClaims = accessToken != null ? accessToken.getValue() : null);
        if (StringUtils.isNotBlank((CharSequence)tokenForClaims) && (StringUtils.isNotBlank((CharSequence)this.configuration.getGroupsClaim()) || StringUtils.isNotBlank((CharSequence)this.configuration.getRolesClaim()))) {
            this.addAuthoritiesFromToken(user, tokenForClaims);
        }
        authenticationToken.setDetails((Object)new TokenDetails(accessToken, idToken, this.configuration.getBeanName()));
        return authenticationToken;
    }

    protected JWTHelper decodeAndValidateJwt(String jwt) {
        if (jwt == null) {
            LOGGER.warn("No JWT provided for decoding.");
            return null;
        }
        try {
            return new JWTHelper(jwt);
        }
        catch (Exception e) {
            LOGGER.error("Failed to decode or validate JWT", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAuthoritiesFromToken(User user, String tokenString) {
        JWTHelper helper;
        LOGGER.info("Syncing authorities from token claims.");
        try {
            helper = new JWTHelper(tokenString);
        }
        catch (Exception e) {
            LOGGER.warn("Token is not a valid JWT; skipping authorities sync from claims.", (Throwable)e);
            return;
        }
        Role currentRole = user.getRole();
        String rolesClaimName = this.configuration.getRolesClaim();
        Object rawRoles = null;
        if (StringUtils.isNotBlank((CharSequence)rolesClaimName)) {
            rawRoles = helper.getClaim(rolesClaimName, Object.class);
        }
        if (rawRoles != null) {
            List<String> oidcRoles = helper.getClaimAsList(rolesClaimName, String.class);
            Role defaultRole = this.configuration.getAuthenticatedDefaultRole() != null ? this.configuration.getAuthenticatedDefaultRole() : Role.USER;
            Role newRole = this.computeRole(oidcRoles, defaultRole);
            user.setRole(newRole);
            LOGGER.info("User role set from token. {} -> {}", (Object)currentRole, (Object)newRole);
        } else {
            LOGGER.info("Roles claim '{}' missing in token -> preserving current role: {}", (Object)rolesClaimName, (Object)currentRole);
        }
        List<Object> oidcGroups = Collections.emptyList();
        if (this.configuration.getGroupsClaim() != null) {
            oidcGroups = helper.getClaimAsList(this.configuration.getGroupsClaim(), String.class);
            LOGGER.info("Groups from token: {}", oidcGroups);
        }
        this.reconcileRemoteGroups(user, new LinkedHashSet<String>(oidcGroups));
        try {
            if (this.userService != null) {
                this.userService.update(user);
            }
        }
        catch (BadRequestServiceEx | NotFoundServiceEx e) {
            LOGGER.error("Updating user with synchronized groups found in claims failed: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (DataIntegrityViolationException e) {
            LOGGER.error("Updating user with synchronized groups data integrity violation: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            LOGGER.info("User updated with the following groups: {}", (Object)user.getGroups());
        }
    }

    private Role computeRole(List<String> rolesFromToken, Role defaultRole) {
        if (rolesFromToken == null || rolesFromToken.isEmpty()) {
            return defaultRole != null ? defaultRole : Role.USER;
        }
        Role resolved = defaultRole != null ? defaultRole : Role.USER;
        for (String r : rolesFromToken) {
            if (r == null) continue;
            String rr = r.trim();
            if (rr.equalsIgnoreCase(Role.ADMIN.name())) {
                return Role.ADMIN;
            }
            if (!rr.equalsIgnoreCase(Role.GUEST.name())) continue;
            resolved = Role.GUEST;
        }
        return resolved;
    }

    private String normalizeGroupName(String name) {
        if (name == null) {
            return null;
        }
        return this.configuration.isGroupNamesUppercase() ? name.toUpperCase(Locale.ROOT) : name;
    }

    private Set<Long> remoteGroupIdsForCurrentProvider() {
        if (this.userGroupService == null || this.configuration == null) {
            return Collections.emptySet();
        }
        String provider = this.configuration.getProvider();
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>();
        try {
            Collection groups = this.userGroupService.findByAttribute(SOURCE_SERVICE_USER_GROUP_ATTRIBUTE_NAME, Collections.singletonList(provider), true);
            if (groups != null) {
                for (UserGroup g : groups) {
                    if (g == null || g.getId() == null) continue;
                    ids.add(g.getId());
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to resolve remote groups for provider '{}': {}", (Object)provider, (Object)e.getMessage());
        }
        return ids;
    }

    private void reconcileRemoteGroups(User user, Set<String> newGroupNamesRaw) {
        String provider = this.configuration.getProvider();
        if (StringUtils.isBlank((CharSequence)provider)) {
            LOGGER.warn("Provider name is empty; skipping remote group reconciliation.");
            return;
        }
        if (user.getGroups() == null) {
            user.setGroups(new LinkedHashSet());
        }
        Set newGroupNames = newGroupNamesRaw.stream().filter(Objects::nonNull).map(this::normalizeGroupName).collect(Collectors.toCollection(LinkedHashSet::new));
        Set<Long> providerRemoteIds = this.remoteGroupIdsForCurrentProvider();
        Set toRemove = user.getGroups().stream().filter(g -> g != null && g.getId() != null && providerRemoteIds.contains(g.getId())).filter(g -> !newGroupNames.contains(this.normalizeGroupName(g.getGroupName()))).collect(Collectors.toCollection(LinkedHashSet::new));
        for (UserGroup g2 : toRemove) {
            try {
                this.userGroupService.deassignUserGroup(user.getId().longValue(), g2.getId().longValue());
                LOGGER.info("Removed remote group '{}' for provider '{}' from user {}", (Object)g2.getGroupName(), (Object)provider, (Object)user.getId());
            }
            catch (NotFoundServiceEx e) {
                LOGGER.warn("Deassign failed for group '{}' from user {}: {}", (Object)g2.getGroupName(), (Object)user.getId(), (Object)e.getMessage());
            }
        }
        user.getGroups().removeAll(toRemove);
        for (String groupName : newGroupNames) {
            UserGroup group = this.searchGroup(groupName);
            if (group == null) {
                group = this.createUserGroup(groupName);
                LOGGER.info("Created remote group '{}' (provider={})", (Object)groupName, (Object)provider);
            } else {
                this.updateGroupSourceServiceAttributes(group);
            }
            UserGroup finalGroup = group;
            boolean alreadyAssigned = user.getGroups().stream().anyMatch(g -> g != null && Objects.equals(g.getId(), finalGroup.getId()));
            if (alreadyAssigned) continue;
            try {
                this.userGroupService.assignUserGroup(user.getId().longValue(), group.getId().longValue());
                user.getGroups().add(group);
                LOGGER.info("Assigned user {} to group '{}'", (Object)user.getId(), (Object)groupName);
            }
            catch (NotFoundServiceEx e) {
                LOGGER.error("Assignment of user {} to group '{}' failed: {}", (Object)user.getId(), (Object)groupName, (Object)e.getMessage());
            }
        }
        LinkedHashMap<String, UserGroup> byName = new LinkedHashMap<String, UserGroup>();
        for (UserGroup g3 : user.getGroups()) {
            byName.put(this.normalizeGroupName(g3.getGroupName()), g3);
        }
        user.setGroups(new LinkedHashSet(byName.values()));
    }

    private UserGroup searchGroup(String groupName) {
        UserGroup ug;
        if (this.userGroupService == null) {
            return null;
        }
        if (this.configuration.isGroupNamesUppercase() && (ug = this.userGroupService.get(groupName.toUpperCase())) != null) {
            return ug;
        }
        return this.userGroupService.get(groupName);
    }

    private void updateGroupSourceServiceAttributes(UserGroup group) {
        if (group == null || group.getId() == null) {
            return;
        }
        try {
            this.userGroupService.upsertAttribute(group.getId().longValue(), SOURCE_SERVICE_USER_GROUP_ATTRIBUTE_NAME, this.configuration.getProvider());
        }
        catch (BadRequestServiceEx | NotFoundServiceEx e) {
            LOGGER.warn("Could not upsert sourceService for group '{}': {}", (Object)group.getGroupName(), (Object)e.getMessage());
        }
    }

    private UserGroup createUserGroup(String groupName) {
        UserGroup group = new UserGroup();
        group.setGroupName(this.configuration.isGroupNamesUppercase() ? groupName.toUpperCase() : groupName);
        group.setAttributes(List.of(this.createUserGroupSourceServiceAttribute(this.configuration.getProvider())));
        if (this.userGroupService != null) {
            try {
                long groupId = this.userGroupService.insert(group);
                group = this.userGroupService.get(groupId);
                LOGGER.info("inserted group id: {}", (Object)group.getGroupName());
            }
            catch (BadRequestServiceEx e) {
                LOGGER.error("Saving new group found in claims failed");
            }
        }
        return group;
    }

    private UserGroupAttribute createUserGroupSourceServiceAttribute(String remoteService) {
        UserGroupAttribute userGroupAttribute = new UserGroupAttribute();
        userGroupAttribute.setName(SOURCE_SERVICE_USER_GROUP_ATTRIBUTE_NAME);
        userGroupAttribute.setValue(remoteService);
        return userGroupAttribute;
    }

    protected User retrieveUserWithAuthorities(String username, HttpServletRequest request, HttpServletResponse response) {
        User user = null;
        if (username != null && this.userService != null) {
            try {
                user = this.userService.get(username);
            }
            catch (NotFoundServiceEx notFoundServiceEx) {
                LOGGER.info("User with username {} not found.", (Object)username);
            }
        }
        if (user == null) {
            try {
                user = this.createUser(username, null, "");
            }
            catch (BadRequestServiceEx | NotFoundServiceEx e) {
                LOGGER.error("Error while auto-creating the user: {}", (Object)username, (Object)e);
            }
        }
        return user;
    }

    protected User createUser(String userName, String credentials, Object rawUser) throws BadRequestServiceEx, NotFoundServiceEx {
        User user = new User();
        user.setName(userName);
        user.setNewPassword(credentials);
        user.setEnabled(true);
        UserAttribute userAttribute = new UserAttribute();
        userAttribute.setName("CONFIGURATION_NAME");
        userAttribute.setValue(this.configuration.getBeanName());
        user.setAttribute(Collections.singletonList(userAttribute));
        HashSet groups = new HashSet();
        user.setGroups(groups);
        user.setRole(Role.USER);
        if (this.userService != null && this.configuration.isAutoCreateUser()) {
            long id = this.userService.insert(user);
            user = new User(user);
            user.setId(Long.valueOf(id));
        }
        return user;
    }

    public void afterPropertiesSet() {
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Authentication success. Updating SecurityContextHolder to contain: {}", (Object)authResult);
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        this.addRequestAttributes(request, authResult);
        request.setAttribute("PROVIDER", (Object)this.configuration.getProvider());
    }

    private void addRequestAttributes(HttpServletRequest request, Authentication authentication) {
        TokenDetails tokenDetails;
        if (authentication != null && (tokenDetails = this.tokenDetails(authentication)) != null && tokenDetails.getAccessToken() != null) {
            OAuth2AccessToken accessToken = tokenDetails.getAccessToken();
            request.setAttribute("access_token", (Object)accessToken.getValue());
            if (tokenDetails.getIdToken() != null) {
                request.setAttribute("id_token", (Object)tokenDetails.getIdToken());
            }
            if (accessToken.getRefreshToken() != null) {
                request.setAttribute("refresh_token", (Object)accessToken.getRefreshToken().getValue());
            }
            request.setAttribute("PROVIDER", (Object)this.configuration.getProvider());
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        if (failed instanceof AccessTokenRequiredException) {
            SecurityContextHolder.clearContext();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Authentication request failed:", (Throwable)failed);
                LOGGER.debug("Cleared SecurityContextHolder.");
            }
        }
    }

    public static enum OAuth2AuthenticationType {
        BEARER,
        USER;

    }
}

