/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.security;

import it.geosolutions.geostore.core.security.ExpressionUserMapper;
import java.util.Map;
import net.sf.json.JSONObject;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;

public class JSONExpressionUserMapper
extends ExpressionUserMapper {
    public JSONExpressionUserMapper(Map<String, String> attributeMappings) {
        super(attributeMappings);
        this.evaluationContext.addPropertyAccessor(new PropertyAccessor(){

            public void write(EvaluationContext ctx, Object target, String name, Object value) throws AccessException {
            }

            public TypedValue read(EvaluationContext ctx, Object target, String name) throws AccessException {
                if (target instanceof JSONObject) {
                    JSONObject details = (JSONObject)target;
                    return new TypedValue(details.get(name));
                }
                return null;
            }

            public Class[] getSpecificTargetClasses() {
                return new Class[]{JSONObject.class};
            }

            public boolean canWrite(EvaluationContext ctx, Object target, String name) throws AccessException {
                return false;
            }

            public boolean canRead(EvaluationContext ctx, Object target, String name) throws AccessException {
                return target instanceof JSONObject;
            }
        });
    }

    @Override
    protected Object preProcessDetails(Object details) {
        if (details instanceof String) {
            details = JSONObject.fromObject((Object)details);
        }
        return super.preProcessDetails(details);
    }
}

