/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.security.ldap;

import it.geosolutions.geostore.core.security.ldap.LdapUserDetailsWithAttributes;
import java.util.Collection;
import java.util.Map;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetails;
import org.springframework.security.ldap.userdetails.LdapUserDetailsMapper;

public class CustomAttributesLdapUserDetailsMapper
extends LdapUserDetailsMapper {
    Map<String, String> attributeMappings;

    public CustomAttributesLdapUserDetailsMapper(Map<String, String> attributeMappings) {
        this.attributeMappings = attributeMappings;
    }

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        LdapUserDetails details = (LdapUserDetails)super.mapUserFromContext(ctx, username, authorities);
        LdapUserDetailsWithAttributes detailsWithAttributes = new LdapUserDetailsWithAttributes(details);
        for (String attributeName : this.attributeMappings.keySet()) {
            detailsWithAttributes.setAttribute(attributeName, ctx.getStringAttribute(this.attributeMappings.get(attributeName)));
        }
        return detailsWithAttributes;
    }
}

