/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.security.password;

import it.geosolutions.geostore.core.security.password.AbstractGeoStorePasswordEncoder;
import it.geosolutions.geostore.core.security.password.PasswordEncodingType;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.apache.commons.codec.binary.Base64;
import org.springframework.dao.DataAccessException;

public class GeoStoreAESEncoder
extends AbstractGeoStorePasswordEncoder {
    private static final byte[] DEFALULT_KEY = "installation dependant key needed".substring(0, 16).getBytes();
    private byte[] key = DEFALULT_KEY;

    public void setKey(String key) {
        this.key = key.substring(0, 16).getBytes();
    }

    @Override
    protected PasswordEncoder createStringEncoder() {
        return null;
    }

    @Override
    protected AbstractGeoStorePasswordEncoder.CharArrayPasswordEncoder createCharEncoder() {
        return null;
    }

    @Override
    public PasswordEncodingType getEncodingType() {
        return PasswordEncodingType.GEOSTORE;
    }

    @Override
    public boolean isPasswordValid(String encPass, String rawPass, Object salt) throws DataAccessException {
        if (encPass == null) {
            return false;
        }
        return rawPass.equals(this.decode(encPass));
    }

    @Override
    public String encodePassword(char[] rawPass, Object salt) throws DataAccessException {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(this.key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, keySpec);
            byte[] b = new byte[rawPass.length];
            for (int i = 0; i < b.length; ++i) {
                b[i] = (byte)rawPass[i];
            }
            byte[] input = b;
            byte[] encrypted = cipher.doFinal(input);
            byte[] output = Base64.encodeBase64((byte[])encrypted);
            return new String(output);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Error while encoding", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new RuntimeException("Error while encoding", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new RuntimeException("Error while encoding", ex);
        }
        catch (BadPaddingException ex) {
            throw new RuntimeException("Error while encoding", ex);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Error while encoding", ex);
        }
    }

    @Override
    public String decode(String encPass) throws UnsupportedOperationException {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(this.key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, keySpec);
            byte[] de64 = Base64.decodeBase64((String)encPass);
            byte[] decrypted = cipher.doFinal(de64);
            return new String(decrypted);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Error while encoding", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new RuntimeException("Error while encoding", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new RuntimeException("Error while encoding", ex);
        }
        catch (BadPaddingException ex) {
            throw new RuntimeException("Error while encoding", ex);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeException("Error while encoding", ex);
        }
    }

    @Override
    public boolean isResponsibleForEncoding(String encPass) {
        if (encPass == null) {
            return false;
        }
        String[] split = encPass.split(":");
        if (split.length == 0) {
            return true;
        }
        String prefix = split[0];
        return !prefix.equals("crypt1") && !prefix.equals("crypt2") && !prefix.equals("digest1") && !prefix.equals("empty") && !prefix.equals("plain");
    }
}

