/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.security;

import it.geosolutions.geostore.core.security.GrantedAuthoritiesMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class SimpleGrantedAuthoritiesMapper
implements GrantedAuthoritiesMapper {
    private Map<String, String> mappings = new HashMap<String, String>();
    private boolean dropUnmapped = false;
    private static final Log logger = LogFactory.getLog(SimpleGrantedAuthoritiesMapper.class);

    public SimpleGrantedAuthoritiesMapper(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    @Override
    public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
        if (this.mappings.isEmpty()) {
            return authorities;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (GrantedAuthority grantedAuthority : authorities) {
            String src = grantedAuthority.getAuthority();
            if (this.mappings.containsKey(src)) {
                String dst = this.mappings.get(grantedAuthority.getAuthority());
                result.add(new SimpleGrantedAuthority(dst));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Mapping authority: " + src + " --> " + dst));
                continue;
            }
            if (this.dropUnmapped) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Dropping unmapped authority: " + src));
                continue;
            }
            result.add(grantedAuthority);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Adding unmapped authority: " + src));
        }
        return result;
    }

    public void setDropUnmapped(boolean dropUnmapped) {
        this.dropUnmapped = dropUnmapped;
    }
}

