/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.security.ExpressionUserMapper;
import it.geosolutions.geostore.core.security.JSONExpressionUserMapper;
import it.geosolutions.geostore.core.security.MapExpressionUserMapper;
import it.geosolutions.geostore.core.security.MockUserDetailsWithAttributes;
import it.geosolutions.geostore.core.security.UserDetailsExpressionUserMapper;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpressionUserMapperTest {
    ExpressionUserMapper mapper;
    private Map<String, String> attributeMappings;
    String SAMPLE_JSON = "{\"user_id\":\"123\",\"email\":\"myemail@email.com\"}";

    @Before
    public void setUp() {
        this.attributeMappings = new HashMap<String, String>();
    }

    @Test
    public void testUserDetailsMapping() {
        MockUserDetailsWithAttributes detailsWithAttributes = new MockUserDetailsWithAttributes();
        this.mapper = new UserDetailsExpressionUserMapper(this.attributeMappings);
        User user = new User();
        detailsWithAttributes.getAttributes().put("sample", "mock");
        this.attributeMappings.put("transformed", "sample");
        this.mapper.mapUser((Object)detailsWithAttributes, user);
        Assert.assertEquals((long)1L, (long)user.getAttribute().size());
        Assert.assertEquals((Object)"transformed", (Object)((UserAttribute)user.getAttribute().get(0)).getName());
        Assert.assertEquals((Object)"mock", (Object)((UserAttribute)user.getAttribute().get(0)).getValue());
    }

    @Test
    public void testJsonsMapping() {
        this.mapper = new JSONExpressionUserMapper(this.attributeMappings);
        User user = new User();
        this.attributeMappings.put("transformed", "email");
        this.mapper.mapUser((Object)this.SAMPLE_JSON, user);
        Assert.assertEquals((long)1L, (long)user.getAttribute().size());
        Assert.assertEquals((Object)"transformed", (Object)((UserAttribute)user.getAttribute().get(0)).getName());
        Assert.assertEquals((Object)"myemail@email.com", (Object)((UserAttribute)user.getAttribute().get(0)).getValue());
    }

    @Test
    public void testMapMapping() {
        this.mapper = new MapExpressionUserMapper(this.attributeMappings);
        User user = new User();
        this.attributeMappings.put("transformed", "my_email");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("my_email", "myemail@email.com");
        this.mapper.mapUser(attributes, user);
        Assert.assertEquals((long)1L, (long)user.getAttribute().size());
        Assert.assertEquals((Object)"transformed", (Object)((UserAttribute)user.getAttribute().get(0)).getName());
        Assert.assertEquals((Object)"myemail@email.com", (Object)((UserAttribute)user.getAttribute().get(0)).getValue());
    }
}

