/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.core.security.ldap;

import it.geosolutions.geostore.core.ldap.MockDirContextOperations;
import it.geosolutions.geostore.core.security.UserDetailsWithAttributes;
import it.geosolutions.geostore.core.security.ldap.CustomAttributesLdapUserDetailsMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class CustomAttributesLdapUserDetailsMapperTest {
    private static final String SAMPLE_USERNAME = "username";
    private CustomAttributesLdapUserDetailsMapper mapper;
    private Map<String, String> attributeMappings;
    private Collection<GrantedAuthority> authorities;
    MockDirContextOperations ctx;

    @Before
    public void setUp() {
        this.attributeMappings = new HashMap<String, String>();
        this.authorities = Collections.EMPTY_LIST;
        this.mapper = new CustomAttributesLdapUserDetailsMapper(this.attributeMappings);
        this.ctx = new MockDirContextOperations();
    }

    @Test
    public void testMappings() {
        this.ctx.getLdapAttributes().put("cn", "mock");
        this.attributeMappings.put("FullName", "cn");
        UserDetails details = this.mapper.mapUserFromContext((DirContextOperations)this.ctx, SAMPLE_USERNAME, this.authorities);
        Assert.assertTrue((boolean)(details instanceof UserDetailsWithAttributes));
        UserDetailsWithAttributes detailsWithAttribute = (UserDetailsWithAttributes)details;
        Assert.assertEquals((Object)"mock", (Object)detailsWithAttribute.getAttribute("FullName"));
    }
}

