/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.dto.search;

import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.services.dto.search.AndFilter;
import it.geosolutions.geostore.services.dto.search.AttributeFilter;
import it.geosolutions.geostore.services.dto.search.BaseField;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.NotFilter;
import it.geosolutions.geostore.services.dto.search.OrFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;

public class SearchFilterTest
extends TestCase {
    protected final Logger LOGGER = LogManager.getLogger(((Object)((Object)this)).getClass());

    protected void setUp() throws Exception {
        super.setUp();
        if (this.LOGGER.isInfoEnabled()) {
            this.LOGGER.info("=============================== " + this.getName());
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("=============================== " + this.getName());
        }
    }

    @Test
    public void testAndMarshallUnmarshall() throws JAXBException {
        FieldFilter base1 = new FieldFilter(BaseField.NAME, "*test*", SearchOperator.LIKE);
        AttributeFilter att1 = new AttributeFilter("att1", "0.0", DataType.NUMBER, SearchOperator.GREATER_THAN);
        AttributeFilter att2 = new AttributeFilter("att2", "attval", DataType.STRING, SearchOperator.EQUAL_TO);
        AndFilter andatt = new AndFilter((SearchFilter)att1, (SearchFilter)att2, new SearchFilter[0]);
        AndFilter orfinal = new AndFilter((SearchFilter)base1, (SearchFilter)andatt, new SearchFilter[0]);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("FILTER: " + String.valueOf(orfinal));
        }
        this.marshallUnmarshallSearch((SearchFilter)orfinal);
    }

    @Test
    public void testFieldMarshallUnmarshall() throws JAXBException {
        FieldFilter sf = new FieldFilter(BaseField.NAME, "*test*", SearchOperator.LIKE);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("FILTER: " + String.valueOf(sf));
        }
        this.marshallUnmarshallSearch((SearchFilter)sf);
    }

    private void marshallUnmarshallSearch(SearchFilter sf) throws JAXBException {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Marshalling: " + String.valueOf(sf));
        }
        StringWriter sw = new StringWriter();
        JAXB.marshal((Object)sf, (Writer)sw);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Marshalled into: " + sw.toString());
        }
        StringReader sr = new StringReader(sw.getBuffer().toString());
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Unmarshalling...");
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Creating JAXB context by hand...");
        }
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{SearchFilter.class, AndFilter.class, AttributeFilter.class, FieldFilter.class, NotFilter.class, OrFilter.class});
        SearchFilter sfOut = (SearchFilter)jc.createUnmarshaller().unmarshal((Reader)sr);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Unmarshalled: " + String.valueOf(sfOut));
        }
    }

    @Test
    public void testXMLParsing() {
        String xmlFilter = "<AND><FIELD><field>NAME</field><operator>LIKE</operator><value>*test*</value></FIELD><AND><ATTRIBUTE><name>attr1</name><operator>EQUAL_TO</operator><type>STRING</type><value>value2</value></ATTRIBUTE><ATTRIBUTE><name>attr2</name><operator>GREATER_THAN</operator><type>NUMBER</type><value>1.0</value></ATTRIBUTE></AND></AND>";
        StringReader reader = new StringReader(xmlFilter);
        AndFilter searchFilter = (AndFilter)JAXB.unmarshal((Reader)reader, AndFilter.class);
        SearchFilterTest.assertNotNull((Object)searchFilter);
        List filters = searchFilter.getFilters();
        for (SearchFilter filter : filters) {
            if (filter instanceof FieldFilter) {
                FieldFilter fieldFilter = (FieldFilter)filter;
                SearchFilterTest.assertEquals((Object)BaseField.NAME, (Object)fieldFilter.getField());
                SearchFilterTest.assertEquals((Object)SearchOperator.LIKE, (Object)fieldFilter.getOperator());
                SearchFilterTest.assertEquals((String)"*test*", (String)fieldFilter.getValue());
                continue;
            }
            if (filter instanceof AndFilter) {
                AttributeFilter attrFilter;
                AndFilter andFilter = (AndFilter)filter;
                List andFilters = andFilter.getFilters();
                if (andFilters.get(0) instanceof AttributeFilter) {
                    attrFilter = (AttributeFilter)andFilters.get(0);
                    SearchFilterTest.assertEquals((String)"attr1", (String)attrFilter.getName());
                    SearchFilterTest.assertEquals((Object)SearchOperator.EQUAL_TO, (Object)attrFilter.getOperator());
                    SearchFilterTest.assertEquals((Object)DataType.STRING, (Object)attrFilter.getType());
                    SearchFilterTest.assertEquals((String)"value2", (String)attrFilter.getValue());
                } else {
                    SearchFilterTest.fail((String)"Wrong type instance!");
                }
                if (andFilters.get(1) instanceof AttributeFilter) {
                    attrFilter = (AttributeFilter)andFilters.get(1);
                    SearchFilterTest.assertEquals((String)attrFilter.getName(), (String)"attr2");
                    SearchFilterTest.assertEquals((Object)attrFilter.getOperator(), (Object)SearchOperator.GREATER_THAN);
                    SearchFilterTest.assertEquals((Object)attrFilter.getType(), (Object)DataType.NUMBER);
                    SearchFilterTest.assertEquals((String)attrFilter.getValue(), (String)"1.0");
                    continue;
                }
                SearchFilterTest.fail((String)"Wrong type instance!");
                continue;
            }
            SearchFilterTest.fail((String)"Wrong type instance!");
        }
    }
}

